pro irc_list_fits_read,imagefile,NIR_image,MIRS_image,MIRL_Image,n_nir,n_mir, $
                       header_nir_n,header_mirs_n,header_mirl_n, $
                       separate=separate,dir=dir,imagelist=imagelist

; images are read from a input list.
; types of images (NIR/MIRS/MIRL) are automatically judged,
; and they will be stored in different arrays.
;
; input: imagelist (a plain ascii text for specifying file names)
; output: NIR_image, MIRS_image, MIRL_image: arrays of each chip
;    image[x,y,subframe_id,exp_cycle]
; n_nir,n_mir: number of frames for NIR or MIRs frames
;
; keyword: separate: in case when MIR-L and MIR-S are provided with two separate frames

  if keyword_set(dir) then cd,dir

  if defined(imagelist) then begin
     imagename=imagelist
     no_image=n_elements(imagelist)
  endif else begin
     READCOL, imagefile, FORMAT='A', imagename,/silent
     s = SIZE(imagename) & no_image = s[1]
  endelse

  n_nir=0 & n_mir=0

  FOR i = 0, no_image-1 DO BEGIN
     GET_LUN,U & openr,U,imagename[i]
     mrd_hread,U,header,status
     CLOSE,U & FREE_LUN,U
     
     sxdelpar,header,'EMBDTI'   ;this should be removed!
     
     naxis1=fix(fxpar(header,'NAXIS1')) & naxis2=fix(fxpar(header,'NAXIS2'))
     IF naxis1 EQ !IRC_SPECRED_CHIPINFO.ncol_nir || naxis1 EQ !IRC_SPECRED_CHIPINFO.nrow_nir then n_nir+=1
     IF naxis1 EQ !IRC_SPECRED_CHIPINFO.ncol_mir then n_mir+=1
  ENDFOR

  temp_temp = MRDFITS(imagename[0], 0, hdr, /silent)
  sxdelpar,hdr,'EMBDTI'         ;this should be removed!

  s=size(temp_temp,/type)
; n_header_max=n_elements(header)
  if n_nir GT 0 then begin
     NIR_image = make_array(naxis1,naxis2,2,n_nir,type=s)
     ; ncol and nrow are swapped, since before NIR rawtation.
     header_nir_n=strarr(!IRC_SPECRED_MISC.max_n_header,n_nir)
  endif
  
  if n_mir GT 0 then begin
     MIRS_image = make_array(!IRC_SPECRED_CHIPINFO.ncol_mir, !IRC_SPECRED_CHIPINFO.nrow_mir, 4, n_mir,type=s)
     MIRL_image = make_array(!IRC_SPECRED_CHIPINFO.ncol_mir, !IRC_SPECRED_CHIPINFO.nrow_mir, 4, n_mir,type=s)
     header_mirs_n=strarr(!IRC_SPECRED_MISC.max_n_header,n_mir)
     header_mirl_n=strarr(!IRC_SPECRED_MISC.max_n_header,n_mir)
  endif
  
  n=0 & m=0
  FOR i = 0, no_image-1 DO BEGIN
     temp_image = MRDFITS(imagename[i], 0, hdr, /silent)
     sxdelpar,hdr,'EMBDTI'      ;this should be removed!
     naxis1=fix(fxpar(hdr,'NAXIS1'))
     s=size(temp_image) & dim=s[0] & n_subframe=s[3]
     IF (naxis1 EQ !IRC_SPECRED_CHIPINFO.ncol_nir || naxis1 EQ !IRC_SPECRED_CHIPINFO.nrow_nir) then BEGIN
        if dim EQ 2 then begin  ; in case of single image without multiple exposure cycle
           NIR_image[*,*,0,n] = temp_image
           NIR_image[*,*,1,n] = temp_image
        endif else begin
           NIR_image[*,*,*,n] = temp_image
        endelse
        n_hdr=n_elements(hdr)
        header_nir_n[0:n_hdr-1,n]=hdr
        n+=1
     ENDIF ELSE begin
        IF (naxis1 EQ !IRC_SPECRED_CHIPINFO.ncol_mir) then BEGIN ; the case of MIR
           if keyword_set(separate) then begin
              if dim EQ 2 then begin ; in case of single image without multiple exposure cycle
                 MIRS_image[*,*,0,m] = temp_image[*,0:255]
                 MIRL_image[*,*,0,m] = temp_image[*,0:255]
                 MIRS_image[*,*,1,m] = temp_image[*,0:255]
                 MIRL_image[*,*,1,m] = temp_image[*,0:255]
                 MIRS_image[*,*,2,m] = temp_image[*,0:255]
                 MIRL_image[*,*,2,m] = temp_image[*,0:255]
                 MIRS_image[*,*,3,m] = temp_image[*,0:255]
                 MIRL_image[*,*,3,m] = temp_image[*,0:255]
              endif else begin
                 if n_subframe EQ 4 then begin
                    MIRS_image[*,*,*,m] = temp_image[*,0:255,*]
                    MIRL_image[*,*,*,m] = temp_image[*,0:255,*]
                 endif else begin
                    MIRS_image[*,*,0,m] = temp_image[*,0:255,0]
                    MIRS_image[*,*,1,m] = temp_image[*,0:255,1]
                    MIRS_image[*,*,2,m] = temp_image[*,0:255,1]
                    MIRS_image[*,*,3,m] = temp_image[*,0:255,1]

                    MIRL_image[*,*,0,m] = temp_image[*,0:255,0]
                    MIRL_image[*,*,1,m] = temp_image[*,0:255,1]
                    MIRL_image[*,*,2,m] = temp_image[*,0:255,1]
                    MIRL_image[*,*,3,m] = temp_image[*,0:255,1]
                 endelse
              endelse
           endif else begin     ; when not separated
              if dim EQ 2 then begin ; in case of single image without multiple exposure cycle
                 MIRS_image[*,*,0,m] = temp_image[*,0:255]
                 MIRL_image[*,*,0,m] = temp_image[*,256:511]
                 MIRS_image[*,*,1,m] = temp_image[*,0:255]
                 MIRL_image[*,*,1,m] = temp_image[*,256:511]
                 MIRS_image[*,*,2,m] = temp_image[*,0:255]
                 MIRL_image[*,*,2,m] = temp_image[*,256:511]
                 MIRS_image[*,*,3,m] = temp_image[*,0:255]
                 MIRL_image[*,*,3,m] = temp_image[*,256:511]
              endif else begin
                 if n_subframe EQ 4 then begin
                    MIRS_image[*,*,*,m] = temp_image[*,0:255,*]
                    MIRL_image[*,*,*,m] = temp_image[*,256:511,*]
                 endif else begin ; EQ 2 for short/long frames
                    MIRS_image[*,*,0,m] = temp_image[*,0:255,0]
                    MIRS_image[*,*,1,m] = temp_image[*,0:255,1]
                    MIRS_image[*,*,2,m] = temp_image[*,0:255,1]
                    MIRS_image[*,*,3,m] = temp_image[*,0:255,1]
                    
                    MIRL_image[*,*,0,m] = temp_image[*,256:511,0]
                    MIRL_image[*,*,1,m] = temp_image[*,256:511,1]
                    MIRL_image[*,*,2,m] = temp_image[*,256:511,1]
                    MIRL_image[*,*,3,m] = temp_image[*,256:511,1]
                 endelse
              endelse
           Endelse
           n_hdr=n_elements(hdr)
           header_mirs_n[0:n_hdr-1,m]=hdr & header_mirl_n[0:n_hdr-1,m]=hdr
           m+=1

        endif

     endelse
     
  ENDFOR
  
END
