pro irc_make_avgimage,inimage,outimage,mask=mask,expmap=expmap

dim=size(inimage)
x_size=dim[1] & y_size=dim[2] & z_size=dim[3]

outimage=fltarr(x_size,y_size)
expmap=intarr(x_size,y_size)

if keyword_set(mask) EQ 0 then begin

for i=0,x_size-1 do begin
    for j=0,y_size-1 do begin
        outimage[i,j]=mean(inimage[i,j,0,*])
    endfor
endfor

endif else begin; if mask cube is set in the command line...

clip_sig=3; 3 sigma clipping

for i=0,x_size-1 do begin
    for j=0,y_size-1 do begin
        stacK_frame=where(mask[i,j,*] NE 0,count)
        if count GE 3 then begin
            meanclip,inimage[i,j,stack_frame],mean_tmp,sigma,clipsig=clip_sig
        endif else begin
            if count NE 0 then $
            mean_tmp=mean(inimage[i,j,stack_frame]) $
            else mean_tmp=0.
        endelse
        outimage[i,j]=mean_tmp
        expmap[i,j]=count
    endfor
endfor

endelse

end
