PRO irc_scombine_N,inimage,avgimage,rmsimage

; combine over exp_cycle per each spec aperture
; use irc_imcombine_N for combining imag data (with no spec subframe)
;
; input: inimage[x,y,subframe_id,exposure_cycle,source_id]
;    subframe_id=0,1 for N
;    subframe_id=0,1,2,3 for M
;    exposure_cycle=0,1,2,...N
;    source_id=no of sources detected in a reference image
; output: avgimage[x,y,subframe_id], rmsimage[x,y,long_shoft_id,source_id]
;    long_shoft_id=0 for shoft
;    long_short_id=1 for long
;    source_id=no of sources detected in a reference image

s=size(inimage[0,0,*,0])
ncol=s[1]
nrow=s[2]
sub_frame_id_max=s[3]
exp_cycle_max=s[4]
max_source_id=s[5]

;subframe_id_max=n_elements(inimage[0,0,*,0]) ; 4 for MIR, 2 for NIR
;exp_cycle_max=n_elements(inimage[0,0,0,*])
;ncol=n_elements(inimage[*,0,0,0])
;nrow=n_elements(inimage[0,*,0,0])

avgimage=fltarr(ncol,nrow,2,max_source_id)
rmsimage=fltarr(ncol,nrow,2,max_source_id)    ; 2 for (short, long) frames

;
; make a frame list (for short and long)
;

if subframe_id_max EQ 4 then begin ; the case of MIR
    long_frames=intarr(exp_cycle_max/4*3)
    long_frames=[indgen(exp_cycle_max/4)*3+1,indgen(exp_cycle_max/4)*3+2,indgen(exp_cycle_max/4)*3+3]
    
    short_frames=intarr(exp_cycle_max/4)
    short_frames=[indgen(exp_cycle_max/4)*3+0]
endif else begin                ; the case of NIR 
    long_frames=intarr(exp_cycle_max/2)
    long_frames=[indgen(exp_cycle_max/2)*2+1]
    
    short_frames=intarr(exp_cycle_max/2)
    short_frames=[indgen(exp_cycle_max/2)*2+0]
endelse

for source_id=0,max_source_id-1 do begin ; begin source_id_loop
    
    rmsimage_tmp=fltarr(ncol,nrow)
    avgimage_tmp=fltarr(ncol,nrow)
    
;
; processes over only long frames
;
    
    for x=0,ncol-1 do begin
        for y=0,nrow-1 do begin
            rmsimage_tmp[x,y]=sigma(inimage[x,y,long_frames,*,source_id])
            avgimage_tmp[x,y]=mean(inimage[x,y,long_frames,*,source_id])
        endfor
    endfor
    
    rmsimage[*,*,1,source_id]=rmsimage_tmp
    avgimage[*,*,1,source_id]=avgimage_tmp

;
; processes over only short frames
;

for x=0,ncol-1 do begin
    for y=0,nrow-1 do begin
        rmsimage_tmp[x,y]=sigma(inimage[x,y,short_frames,*,source_id])
        avgimage_tmp[x,y]=mean(inimage[x,y,short_frames,*,source_id])
    endfor
endfor

rmsimage[*,*,0,source_id]=rmsimage_tmp
avgimage[*,*,0,source_id]=avgimage_tmp

endfor                          ; of source_id loop

END
