function jansky_to_w_cm2_um,lambda,flux_in_jansky

;lambda: in um
;flux_in_jansky: in jansky
;Return: flux in W/cm^2/um

; 1 Jy =1e-26 W/m2/Hz

; return,flux_in_w_cm2_um*1e4/1e-26*(lambda*1e-6)^2./3e8*1e6 ; convert from W/cm2/um to Jansky
  return,flux_in_jansky/1e4*1e-26/(lambda*1e-6)^2.*3e8/1e6 ; convert from W/cm2/um to Jansky

end
