pro make_mask_n,source_table,specmask3d, $
                remove_all_source=remove_all_source,circular_aperture=circular_aperture,fov_mask=fov_mask,noise_mask=noise_mask

  spec_mask_y_margin=0.

  n_source=n_elements(source_table)
  specmask3d=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)

  x1=round(source_table.spec_x)-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
  x2=round(source_table.spec_y)-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1)/2
  
  for source_id=0,n_source-1 do begin
     if keyword_set(remove_all_source) then begin
        make_wholemask,source_table.spec_x,source_table.spec_y, $
                       source_table.spec_mask_dx,source_table.spec_mask_dy+spec_mask_y_margin, $
                       mask_image,circular_aperture=circular_aperture,fov_mask=fov_mask
     endif else begin
        make_wholemask,source_table.spec_x,source_table.spec_y, $
                       source_table.spec_mask_dx,source_table.spec_mask_dy+spec_mask_y_margin, $
                       mask_image,/remove_source,id=source_id,circular_aperture=circular_aperture,fov_mask=fov_mask
     endelse
     
     if defined(noise_mask) then mask_image*=noise_mask

     if finite(source_table[source_id].image_x) && finite(source_table[source_id].image_y) then begin
        specmask3d_tmp=extrac(mask_image, x1[source_id], x2[source_id], $
                              !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
        
; Since extrac changes NaN to zero, set zero back to NaN
        masked=where(specmask3d_tmp EQ 0.0,count)
        if count NE 0 then specmask3d_tmp[masked]=!values.f_nan
        specmask3d[*,*,source_id]=specmask3d_tmp
     endif else begin
        specmask3d[*,*,source_id]= $
           make_array(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,/float,value=!values.f_nan)
     endelse
  endfor

; trim mask
  s=size(specmask3d) & xsize=s[1] & ysize=s[2]
  specmask3d[0,*,*]=!values.f_nan
  specmask3d[*,0,*]=!values.f_nan
  specmask3d[xsize-1,*,*]=!values.f_nan
  specmask3d[*,ysize-1,*]=!values.f_nan
  
end
