pro make_offspec_for_plot,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table,source_id, $
                          off_specimage_wc_1d,off_specimage_fc_1d, $
                          no_mask=no_mask,stdstar_mode=stdstar_mode, $
                          average_mode=average_mode,whole_aperture=whole_aperture, $
                          bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset

  common measured_offsets,space_shift,nsum
  
; store original params
  space_shift_org=space_shift & nsum_org=nsum
; set bgspec params
  if ~ defined(bg_nsum) then bg_nsum=nsum
  nsum=bg_nsum

  if ~ defined(bg_offset) then bg_offset=10

  space_shift=space_shift_org+bg_offset
  make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              off_specimage_wc_1d_1,off_specimage_fc_1d_1,off_sigmaimage_fc_1d_1, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,average_mode=average_mode,whole_aperture=whole_aperture
  
  space_shift=space_shift_org-bg_offset
  make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              off_specimage_wc_1d_2,off_specimage_fc_1d_2,off_sigmaimage_fc_1d_2, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,average_mode=average_mode,whole_aperture=whole_aperture
  
; set back original params     
  space_shift=space_shift_org & nsum=nsum_org
  
  off_specimage_wc_1d=(off_specimage_wc_1d_1+off_specimage_wc_1d_2)/2.
  off_specimage_fc_1d=(off_specimage_fc_1d_1+off_specimage_fc_1d_2)/2.

  if ~ defined(bg_nsum) then bg_nsum=1
  
end
