pro make_wholemask,x,y,mask_dx,mask_dy,mask, $
                 remove_source=remove_source,id=id,circular_aperture=circular_aperture,fov_mask=fov_mask

; INPUTS:
; x, y: object coordinates for mask
; mask_dx,mask_dy: size of mask in x and y
;
; OUTPUT
; mask
;
; Option
; circular_aperture: if set, make a round mask; else, make a box mask
; remove_soruce: if set, a mask for soruce_id=id will not be created.

  get_chip_dims,xsize,ysize

; mask values definition
  good_mask_value=1. & bad_mask_value=!values.f_nan

;make an mask array
  mask=make_array(xsize,ysize,/float,value=good_mask_value)

  if keyword_set(remove_source) then rmid=id else rmid=-1 ; never match

  n_source=n_elements(x)
; for circle mask
  if keyword_set(circular_aperture) then begin
     yy_min=(y-(mask_dy-1)/2) > 0
     yy_max=(y+(mask_dy-1)/2) < (ysize-1)
     xx_min=(x-(mask_dx-1)/2) > 0
     xx_max=(x+(mask_dx-1)/2) < (xsize-1)
     FOR source_id=0,n_source-1 do begin
        if source_id NE rmid then begin
           for yy=yy_min[source_id],yy_max[source_id] do begin
              for xx=xx_min[source_id],xx_max[source_id] do begin
                 if sqrt((xx-x[source_id])^2.+(yy-y[source_id])^2.) LT (mask_dx[source_id]-1)/2 then mask[xx,yy]=bad_mask_value
              endfor            ; of XX loop
           endfor               ; of YY loop
        endif
     endfor                     ; of source_id loop
     return                     ; back to calling procedure
; for box mask
  endif else begin
     if NP() then begin
        x1_n=round(x-(mask_dx-1)/3)   > 0 < (xsize-1)
        x2_n=round(x+(mask_dx-1)/3-1) > 0 < (xsize-1)
        y1_n=round(y-(mask_dy-1)/2)   > 0 < (ysize-1)
        y2_n=round(y+(mask_dy-1)/2-1) > 0 < (ysize-1)

        x1_w=round(x-(mask_dx-1)/2)   > 0 < (xsize-1)
        x2_w=round(x+(mask_dx-1)/2-1) > 0 < (xsize-1)

        y1_w=round(y-(mask_dy-1)/2)   > 0 < (ysize-1)
        y2_w=round(y-(mask_dy-1)/6-1) > 0 < (ysize-1)
        FOR source_id=0,n_source-1 do begin
           if source_id NE rmid then begin
              if x1_n[source_id] GT x2_n[source_id] then x2_n[source_id]=x1_n[source_id]
              if y1_n[source_id] GT y2_n[source_id] then y2_n[source_id]=y1_n[source_id]
              if x1_w[source_id] GT x2_w[source_id] then x2_w[source_id]=x1_w[source_id]
              if y1_w[source_id] GT y2_w[source_id] then y2_w[source_id]=y1_w[source_id]
; narrow mask
              mask[x1_n[source_id]:x2_n[source_id],y1_n[source_id]:y2_n[source_id]]=bad_mask_value
; wide mask
              mask[x1_w[source_id]:x2_w[source_id],y1_w[source_id]:y2_w[source_id]]=bad_mask_value
           endif
        endfor
     endif else begin
        x1=round(x-(mask_dx-1)/2)   > 0 < (xsize-1)
        x2=round(x+(mask_dx-1)/2-1) > 0 < (xsize-1)
        y1=round(y-(mask_dy-1)/2)   > 0 < (ysize-1)
        y2=round(y+(mask_dy-1)/2-1) > 0 < (ysize-1)
        
        FOR source_id=0,n_source-1 do begin
           if source_id NE rmid then begin
              mask[x1[source_id]:x2[source_id],y1[source_id]:y2[source_id]]=bad_mask_value
           endif                ; of source_id EQ rmid
        endfor                  ; of source_id loop
     endelse
     
     if defined(fov_mask) then mask*=fov_mask
     
  endelse
  
end
