pro mask_grow,mask,mask_grow,grow_width=grow_width

  s=size(mask) & xsize=s[1] & ysize=s[2]
  mask_grow=mask

  if defined(grow_width) EQ 0 then width=1 else width=grow_width

  case width of
     -1: begin                  ; special cross mask
        for y=1,ysize-2 do begin
           for x=1,xsize-2 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-1:x+1,y:y]=!values.f_nan
                 mask_grow[x:x,y-1:y+1]=!values.f_nan
              endif
           endfor
        endfor
     end
     

     1: begin
        for y=1,ysize-2 do begin
           for x=1,xsize-2 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-1:x+1,y-1:y+1]=!values.f_nan
              endif
           endfor
        endfor
     end
     
     2: begin
        for y=2,ysize-3 do begin
           for x=2,xsize-3 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-2:x+2,y-2:y+2]=!values.f_nan
              endif
           endfor
        endfor
     end
     
     3: begin
        for y=3,ysize-4 do begin
           for x=3,xsize-4 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-3:x+3,y-3:y+3]=!values.f_nan
              endif
           endfor
        endfor
     end
     
     else: begin                ; same as widgth=2
        for y=2,ysize-3 do begin
           for x=2,xsize-3 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-2:x+2,y-2:y+2]=!values.f_nan
              endif
           endfor
        endfor
     end
     
  endcase
  
end


