FUNCTION mean_sigma, X, Double = Double, Mdev = Mdev, Sdev = Sdev, $
                 Maxmoment = Maxmoment, NaN = nan, weight=weight

ON_ERROR, 2

if keyword_set( nan ) then begin ;If NaN set, remove NaNs and recurse.
    whereNotNaN = where( finite(X), nanCount)
    if nanCount gt 0 then begin
       if defined(weight) then $
        return, mean_sigma( X[whereNotNan], Double = Double, Mdev = Mdev, $
                        Sdev = Sdev, Maxmoment = Maxmoment, weight=weight[whereNotNan] ) $
                else $
        return, mean_sigma( X[whereNotNan], Double = Double, Mdev = Mdev, $
                        Sdev = Sdev, Maxmoment = Maxmoment ) 
    endif
endif

TypeX = SIZE(X)

nX = TypeX[TypeX[0]+2]
Mean = TOTAL(X) / nX

Var  = !VALUES.F_NAN
Resid = X - Mean

if defined(weight) then $
   Var = (w_mean(Resid^2,weight)*nX - ((w_mean(Resid,weight)*nX)^2)/nX)/((nX-1.0)) $
else  $
   Var = (TOTAL(Resid^2) - (TOTAL(Resid)^2)/nX)/(nX-1.0)

RETURN, [Mean, Var]

END
