pro plot_spec_obs,wave_array_shift,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                  redshift=redshift,mjy=mjy,watt=watt,with_image=with_image,_EXTRA=EXTRA_KEYWORDS,diffuse=diffuse,lambda2=lambda2

  common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

  if ~ defined(redshift) then redshift=0.

  if keyword_set(with_image) then begin
     plot_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth,mJy=mjy,watt=watt,lambda2=lambda2,psym=6,color=white,diffuse=diffuse, $
               xrange=[wave_array_shift[0],wave_array_shift[n_elements(wave_array_shift)-1]],_extra=extra_keywords
  endif else begin
     plot_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth,mJy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $
               xrange=!IRC_SPECRED_SPECPARAM.w_cover,psym=6,color=white,_extra=extra_keywords
  endelse
  
  plot_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth, $
            psym=6,color=blue,_extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse
  
  plot_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth, $
            specimage_fc_1d_smooth-error_n_fc_total,specimage_fc_1d_smooth+error_p_fc_total, $
            wave_array_shift/(1.+redshift)-d_wave_array,wave_array_shift/(1.+redshift)+d_wave_array, $
            color=red,width=0,psym=0,/errorxy,mjy=mjy,watt=watt,lambda2=lambda2,_EXTRA=EXTRA_KEYWORDS,diffuse=diffuse

; overplot the result at the very end for clarity of the plot.
  plot_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth, $
            psym=6,color=blue,_extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse
  
; plot observed spectrum with histograms
  plot_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth, $
            psym=10,color=white,_extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse
  
; plot baseline (flux=0)
  plot_spec,wave_array_shift/(1.+redshift),fltarr(n_elements(wave_array_shift)), $
            linestyle=2,color=white,_extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse
  
end
