PRO read_cohen,X,Y,Z,count,filename,spec=spec

; X for lambda
; Y for flux
; z for flux error

; file format
;                        _________Uncertainties_________
;  Wavelength Irradiance   Total      Local      Global
;  (microns)  (W/cm2/um) (W/cm2/um)    (%)        (%)
;

  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
  
  if defined(filename) EQ 0 then begin
     filename=DIALOG_PICKFILE(PATH=calibdir+'StdSpecData/',filter='*.tem')
     IF(STRLEN(filename) EQ 0) THEN stop
  endif
  
  X=FLTARR(6000) & Y=FLTARR(6000) & z=fltarr(6000)
  dummy=''
  
  if keyword_set(spec) EQ 0 then spec=0 else spec=1
  
  GET_LUN,U & openr,U,filename
  
; search the first line
  for i=0,200 do begin
     READF, U, dummy            ; dummy read for header
     if dummy EQ '  Wavelength Irradiance   Total      Local      Global' then break
  endfor
  
  READF, U, dummy               ; dummy read for header
  READF, U, dummy               ; dummy read for header
  
  i=0
  
  WHILE EOF(U) EQ 0 DO BEGIN
     READF, U, xx,yy,zz
     X[i]=xx
     Y[i]=w_cm2_um_to_jansky(xx,yy) ; convert from W/cm2/um to Jansky
     z[i]=w_cm2_um_to_jansky(xx,zz)
     i=i+1
  ENDWHILE
  
  close,U & FREE_LUN,U
  
  X=X[0:i-1] & Y=Y[0:i-1] & z=z[0:i-1]
  count=i
  
END
