PRO read_irsspec,lambda,flux,d_flux,bit_flag,filename=filename,watt=watt

; read pbcd spectrum of IRS archive

;|order        |wavelength         |flux                |error               |bit-flag            |
;|int          |real               |real                |real                |int                 |
;|             |                   |Jy                  |Jy                  |                    |
; 2             13.90000            0.350679             0.006560             1                    
  
  IRS_DIR='~/hd1.cava/IRS/WRs'
  
  if defined(filename) EQ 0 then begin
     filename=DIALOG_PICKFILE(PATH=IRS_DIR,filter='*.tbl')
     IF(STRLEN(filename) EQ 0) THEN stop
  endif
  
  readcol_comment2,filename,order,lambda,flux,d_flux,bit_flag,format='I,F,F,F,I', $
                   comment1='/',comment2='|',/silent
  good=where(bit_flag EQ 0, count)
;good=where(bit_flag LE 1 && order NE 3, count)
  
  lambda=lambda[good]
    flux=flux[good]
  d_flux=d_flux[good]

  if keyword_set(watt) then begin
       flux=jansky_to_w_cm2_um(lambda,flux)
     d_flux=jansky_to_w_cm2_um(lambda,d_flux)
  endif else begin
     flux=flux*1000.            ; flux in mJy
     d_flux=d_flux*1000.        ; flux in mJy
  endelse

END
