PRO read_target_table,source_table,ext_source_table=ext_source_table, $
                      source_table_offset_x_value=source_table_offset_x_value, $
                      source_table_offset_y_value=source_table_offset_y_value

; Read external target list

  common dir_structure,datadir,calibdir
  
  if keyword_set(ext_source_table) EQ 0 then $
     filename = DIALOG_PICKFILE(FILTER = '*.tbl',title='Target Table Output File Name', path=datadir) $
  else filename=ext_source_table
  
  readcol,filename,x,y,format='F,F'
  
  n_source=n_elements(x)
  print,n_source
  if n_source EQ 0 then message,'Error (read_target_table): No data were found in the target table...Stop!'
  make_default_source_table,source_table,n_source
  source_table.image_x=x-1. & source_table.image_y=y-1.
  
  if defined(source_table_offset_x_value) && defined(source_table_offset_y_value) then begin
     source_table.image_x+=source_table_offset_x_value
     source_table.image_y+=source_table_offset_y_value
  end
  
END
