pro set_mask,mask_output
common frame_type,chip,filter,grism
common dir_structure,datadir,calibdir

case chip of
    0: slitmasklist=calibdir+'MASK/SLITMASK_NIR.lst'
    1: slitmasklist=calibdir+'MASK/SLITMASK_MIRS.lst'
    2: slitmasklist=calibdir+'MASK/SLITMASK_MIRL.lst'
endcase

irc_list_fits_read, slitmasklist, slitmask_nir, slitmask_mirs, slitmask_mirl, $
  n_nir,n_mir, header_nir,header_mirs,header_mirl,dir=calibdir+'MASK/',/separate

case chip of
    0: begin
        mask=slitmask_nir
        header=header_nir
    end
    1: begin
        mask=slitmask_mirs
        header=header_mirs
    end
    2: begin
        mask=slitmask_mirl
        header=header_mirl
    end
endcase

mask_region=where(mask LT 0.)
mask_output=make_array(size(mask,/dimensions),/float,value=1.)
mask_output[mask_region]=!values.f_nan

end
