pro set_outliermask,mask_output
common frame_type,chip,filter,grism
common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

case chip of
    0: slitmasklist=calibdir+'MASK/OUTLIERMASK_NIR.lst'
    1: slitmasklist=calibdir+'MASK/OUTLIERMASK_MIRS.lst'
    2: slitmasklist=calibdir+'MASK/OUTLIERMASK_MIRL.lst'
endcase

irc_list_fits_read, slitmasklist, slitmask_nir, slitmask_mirs, slitmask_mirl, $
                    n_nir,n_mir, header_nir,header_mirs,header_mirl,dir=calibdir+'MASK/',/separate

case chip of
    0: begin
        mask=slitmask_nir
        header=header_nir
    end
    1: begin
        mask=slitmask_mirs
        header=header_mirs
    end
    2: begin
        mask=slitmask_mirl
        header=header_mirl
    end
endcase

mask_region=where(mask EQ 0.,count)
mask_output=make_array(size(mask,/dimensions),/float,value=1.)
mask_output[mask_region]=!values.f_nan

return

if chip EQ 2 then begin
   d = FINDFILE (calibdir+'MASK/outlier_MIRL_tmp.fits', COUNT = count)
   IF count EQ 0 THEN begin
      print,'Warning (set_outliermask): No LG2 special outlier mask was found...Skipping!'
   endif else begin
      mask_tmp=MRDFITS(calibdir+'MASK/outlier_MIRL_tmp.fits', 0, hdr, /silent)
      atv,mask_tmp,/block
;      mask_grow,mask_tmp,mask_tmp_grow,grow_width=1
      mask_output*=mask_tmp;_grow
      print,'Information (set_outliermask): Uses LG2 special outlier mask treatment'
   endelse
endif

end
