pro set_superflat,type,flat,header
  
; common frame_type,chip,filter,grism
  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
  
; SPEC
  case type of
     'spec': begin
        case !IRC_SPECRED_PROCESSTARGET.chip of
           0: case !IRC_SPECRED_PROCESSTARGET.grism of
              0: begin
                 if !IRC_SPECRED_OBSPARAM.Ns_mode then filename=calibdir+'FLAT/SPEC2DFLAT_NP_slit.lst' $
                 else              filename=calibdir+'FLAT/SPEC2DFLAT_NP.lst'
              end
              1: begin
                 if !IRC_SPECRED_OBSPARAM.Np_mode then filename=calibdir+'FLAT/SPEC2DFLAT_NG_slit.lst' $
                 else              filename=calibdir+'FLAT/SPEC2DFLAT_NG.lst'
              end
           endcase
           1: case !IRC_SPECRED_PROCESSTARGET.grism of
              0: begin
                 if !IRC_SPECRED_OBSPARAM.Ns_mode then filename=calibdir+'FLAT/SPEC2DFLAT_SG1_slit.lst' $
                 else filename=calibdir+'FLAT/SPEC2DFLAT_SG1.lst'
              end
              1: begin
                 if !IRC_SPECRED_OBSPARAM.Ns_mode then filename=calibdir+'FLAT/SPEC2DFLAT_SG2_slit.lst' $
                 else filename=calibdir+'FLAT/SPEC2DFLAT_SG2.lst'
              end
           endcase
           2: case !IRC_SPECRED_PROCESSTARGET.grism of
              0: filename=calibdir+'FLAT/SPEC2DFLAT_LG1.lst'
              1: begin
                 if !IRC_SPECRED_OBSPARAM.Ls_mode then filename=calibdir+'FLAT/SPEC2DFLAT_LG2_slit.lst' $
                 else filename=calibdir+'FLAT/SPEC2DFLAT_LG2.lst'
              end
           endcase
        endcase
        irc_list_fits_read,filename,flatimage_nir,flatimage_mirs,flatimage_mirl, $
                           n_nir,n_mir,flatheader_nir,flatheader_mirs,flatheader_mirl, $
                           dir=calibdir+'FLAT/',/SEPARATE
     end
   
     'image': begin
        case !IRC_SPECRED_PROCESSTARGET.chip of
           0: filename=calibdir+'FLAT/IMAG2DFLAT_N3.lst'
           1: filename=calibdir+'FLAT/IMAG2DFLAT_S9W.lst'
           2: filename=calibdir+'FLAT/IMAG2DFLAT_L18W.lst'
        endcase
        irc_list_fits_read,filename,flatimage_nir,flatimage_mirs,flatimage_mirl, $
                           n_nir,n_mir,flatheader_nir,flatheader_mirs,flatheader_mirl, $
                           dir=calibdir+'FLAT/',/SEPARATE
     end
     
  endcase
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
  0: begin flat=flatimage_nir  & header=flatheader_nir  & end
  1: begin flat=flatimage_mirs & header=flatheader_mirs & end
  2: begin flat=flatimage_mirl & header=flatheader_mirl & end
  endcase
  
  if !IRC_SPECRED_PROCESSOPTION.no_fov_mask EQ 1 then begin
     do_mask_load,source_table,fov_mask
     masked=where(finite(fov_mask,/NAN),count)
     if count GT 0 then flat[masked]=1.0
  endif

end
