pro tune_sourcepos,image,x,y,x_new,y_new,x_error,y_error, $
                   box_half_size=box_half_size, $
                   median=median,flux=flux,FWHM=FWHM,use_array=use_array,no_photo=no_photo, $
                   mean_dx=mean_dx,mean_dy=mean_dy,silent=silent

  if ~ defined(box_half_size) then box_half_size=fix(!IRC_SPECRED_CHIPINFO.APPHOTORAD/2) ;+4+1 ; was 4
  
  box_half_size00=!IRC_SPECRED_CHIPINFO.APPHOTORAD+4+2 ; was 4
  
  box_half_size0=box_half_size

  if LG2() && !IRC_SPECRED_PROCESSOPTION.ext_source_table_mode EQ 1B then begin ;widen the search path 
   box_half_size00+=10
   box_half_size0 +=10
endif

  
  s=size(image) & xsize=s[1] & ysize=s[2]
  x_new=x & y_new=y
  n_source=n_elements(x)
  x_error=fltarr(n_source) & y_error=fltarr(n_source) & FWHM=fltarr(n_source) & flux=fltarr(n_source)
  use_array=intarr(n_source) & weight=fltarr(n_source)

  k=0

  if keyword_set(median) then $
     image_med=sigma_filter(image,radius=1,/all,/iterate) $
  else $
     image_med=sigma_filter(image,radius=1,/all,/iterate)
  
  xr=round(x) & yr=round(y)
  
  for source_id=0,n_source-1 do begin
     
; check out-of-FOV
     if xr[source_id] GT xsize-1 || xr[source_id] LT 0 || yr[source_id] GT ysize-1 || yr[source_id] LT 0 then begin
        y_new[source_id]=y[source_id]
        x_new[source_id]=x[source_id]
        flux[source_id]=!values.f_nan
        print,'Warning (tune_sourcepos): '+strim(source_id)+' is out of FOV: '+ $
              strim(xr[source_id])+strim(yr[source_id])
        continue
     end
     
     box_half_size_x=min([xsize-x[source_id],box_half_size0,x[source_id]-0])
     box_half_size_y=min([ysize-y[source_id],box_half_size0,y[source_id]-0])
     box_half_size1=round(min([box_half_size_x,box_half_size_y]))

     box_half_size_x2=min([xsize-x[source_id],box_half_size00,x[source_id]-0])
     box_half_size_y2=min([ysize-y[source_id],box_half_size00,y[source_id]-0])
     box_half_size2=round(min([box_half_size_x2,box_half_size_y2]))

     image_min=image_med[xr[source_id]-box_half_size1>0:xr[source_id]+box_half_size1<(xsize-1), $
                         yr[source_id]-box_half_size1>0:yr[source_id]+box_half_size1<(ysize-1)]
     
     result=mpfit2dpeak_nan(image_min,A, $
                            /tilt,errmsg=errmsg,/positive,chisq=chisq, $
                            estimates=[0,max(image_min), $
                                       !IRC_SPECRED_SOURCEDETECTPARAM.fwhm_for_find+1, $
                                       !IRC_SPECRED_SOURCEDETECTPARAM.fwhm_for_find+1, $
                                       box_half_size1,box_half_size1,0], $
                            dof=dof,perror=perror,bestnorm=bestnorm)

     if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,100.,100.,100.,100.]

     if errmsg NE '' then begin
        GCNTRD, image_min, box_half_size1, box_half_size1, xcen, ycen,3
        if xcen EQ -1 then begin
           errmsg+=': GCNTRD also met a fit error.'
;        A=fltarr(6)
           perror=fltarr(6)     ; dummy
           A[4]=-1              ; to be out of FOV
        endif else begin
;        A=fltarr(6)
           A[4]=xcen & A[5]=ycen
           errmsg=''
           perror=fltarr(6)     ; dummy to clear error
;        print,source_id,': GCNTRD measured!'
        endelse
     endif
     
     FWHM_TMP=(A[2]+A[3])/2.*2.355
     
     if A[4] LT 0. || A[4] GT box_half_size1*2.+1. || A[5] LT 0. || A[5] GT box_half_size1*2.+1. $
        || perror[4] GT 1.0 || perror[5] GT 1.0 $
        || errmsg NE '' || FWHM_TMP GT 10. || FWHM_TMP LT 0.3 || $
        finite(error[4],/NAN) || error[4] EQ 0 $
     then begin                 ; bad fit
        x_new[source_id]=x[source_id] & y_new[source_id]=y[source_id]
        FWHM[source_id]=!values.f_nan
                                ; print error reasons
        if ~ keyword_set(silent) then begin
           case 1 of
              (errmsg NE ''): print,'Warning (tune_sourcepos): ',source_id,' :got error message:     ',errmsg
              ((A[4] LT 0 || A[4] GT box_half_size1*2+1) || (A[5] LT 0 || A[5] GT box_half_size1*2+1)): $
                 print,'Warning (tune_sourcepos): ',source_id,' :source out of FOV:     ', $
                       A[4]-box_half_size1,A[5]-box_half_size1
              (perror[4] GT 1.0 || perror[5] GT 1.0): $
                 print,'Warning (tune_sourcepos): ',source_id,' :offset error too large:', $
                       perror[4],perror[5]
              (FWHM_TMP GT 10.): $
                 print,'Warning (tune_sourcepos): ',source_id,' :source size too large: ', $
                       (A[2]+A[3])/2.*2.355,A[2],A[3]
              (FWHM_TMP LT 0.3): $
                 print,'Warning (tune_sourcepos): ',source_id,' :source size too small: ', $
                       (A[2]+A[3])/2.*2.355,A[2],A[3]
              (finite(error[4],/NAN)): $
                 print,'Warning (tune_sourcepos): ',source_id,' :fitting failed.'
              (error[4] EQ 0): $
                 print,'Warning (tune_sourcepos): ',source_id,' :fitting failed.'
           endcase
        endif
     endif else begin           ; good fit
        x_new[source_id]=A[4]+xr[source_id]-box_half_size1
        y_new[source_id]=A[5]+yr[source_id]-box_half_size1
        x_error[source_id]=perror[4] & y_error[source_id]=perror[5]
        FWHM[source_id]=FWHM_TMP
        use_array[k]=source_id & k+=1
        weight[source_id]=1./(error[4])^2.
;do ap-photo
        if keyword_set(no_photo) EQ 0 then begin
           image_min_nomed=image[xr[source_id]-box_half_size2>0:xr[source_id]+box_half_size2<(xsize-1), $
                                 yr[source_id]-box_half_size2>0:yr[source_id]+box_half_size2<(ysize-1)]
;          aper_mod,image_min_nomed,A[4],A[5],flux0,eflux,sky,skyerr,!IRC_SPECRED_CHIPINFO.ADG, $
           aper_mod,image_min_nomed,box_half_size2,box_half_size2,flux0,eflux,sky,skyerr,!IRC_SPECRED_CHIPINFO.ADG, $
                    !IRC_SPECRED_CHIPINFO.APPHOTORAD, $
                    [!IRC_SPECRED_CHIPINFO.APPHOTORAD+2<box_half_size2, $
                     !IRC_SPECRED_CHIPINFO.APPHOTORAD+4<box_half_size2], $
                    [0,0],/flux,/silent

           flux[source_id]=flux0
        endif else begin
           flux[source_id]=!values.f_nan
        endelse
     endelse
  endfor                        ; of source_id loop

  dx=x_new-x & dy=y_new-y
  
  if k EQ 0 then begin
     print,'Warning (tune_source_pos): No data are available for tuning the source positions!'
     use_array=-1
     mean_dx=0 & mean_dy=0 & sigma_dx=0 & sigma_dy=0
  endif else begin
     use_array=use_array[0:k-1]
     
     meanclip_mod,dx[use_array],mean_dx,sigma_dx,weight=weight[use_array],clipsig=3.
     meanclip_mod,dy[use_array],mean_dy,sigma_dy,weight=weight[use_array],clipsig=3.
     
     print,'Information (tune_source_pos): source mean offset: dx: '+strim(mean_dx[0])+'+-'+strim(sigma_dx[0])+ $
           '  dy: '+strim(mean_dy[0])+'+-'+strim(sigma_dy[0])
  endelse

end
