function wavelength_func, $
   non_array=non_array,at_y=at_y,waveref_pix=waveref_pix
  
  wave_array_pix=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy) ; pix unit
; The following calculates image_y pos. w.r.t. spec apereture.
; waveref: wavelength reference point, as defined in the image Y pos.
  waveref_pix=float((!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1)/2-!IRC_SPECRED_SPECEXTRACTPARAM.y_offset) ; pix unit
  
  if NP() then begin ; for NP
     if !IRC_SPECRED_PROCESSOPTION.NP_linear_mode then begin
        wavelength=!IRC_SPECRED_SPECPARAM.lambda_cen+!IRC_SPECRED_SPECPARAM.wavescale*(wave_array_pix-waveref_pix)
     endif else begin
        wavelength=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
        for y=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1 do wavelength[y]=np_wavesol(wave_array_pix[y])
        wavelength0=wavelength
        shift_wavelength,wavelength0,0.5,wavelength; 1.0 pix shift measured at N6543 (as of 20060914)
     endelse
  endif else wavelength=!IRC_SPECRED_SPECPARAM.lambda_cen+!IRC_SPECRED_SPECPARAM.wavescale*(wave_array_pix-waveref_pix)
  
  if keyword_set(non_array) then return,wavelength[at_y] else return,wavelength

end
