pro wrapcor,inimage,outimage,short=short

; wrap and bitshift correction

; Notse on calculating wrapping conditions:
; NIR saturation: 13500 ADU (without bitshift)
; MIR saturation: 11000 ADU (without bitshift)

; 2^15-13500X4=-21232; 2^15-21232=11536
;; 2^15-10000X4=-7237; 2^15-7232=25536
; 2^15-11000X4=-7237; 2^15-7232=21536

  common frame_type,chip,filter,grism

  s=size(inimage) & if s[0] EQ 2 then subframe_id_max=1 else subframe_id_max=s[3]

  get_chip_dims,xsize,ysize
  outimage=uintarr(xsize,ysize,subframe_id_max)

  for subframe_id=0,subframe_id_max-1 do begin
     tmp=inimage[*,*,subframe_id]
     tmp2=float(tmp)
     case chip of
        0: begin
           for y=0,ysize-1 do begin
              for x=0,xsize-1 do begin
                 tmp3=tmp[x,y]
                 if tmp3 LT -11536              then tmp2[x,y]=float(tmp3)+2.^16. ; was -11953.8
                 if tmp3 GE -11536 && tmp3 LT 0 then tmp2[x,y]=!values.f_nan
                 if tmp3 GE 0                   then tmp2[x,y]=float(tmp3)
              endfor
           endfor
        end
        else: begin
           tmp2*=4.
        end
;              end
;              1: begin
;                tmp3=ishft(tmp[x,y],2)
;:               if tmp3 LT -21536              then tmp2[x,y]=float(tmp3)+2.^16. ; was -11953.8
;;               if tmp3 GE -21536 && tmp3 LT 0 then tmp2[x,y]=!values.f_nan
;;               if tmp3 GE 0 then tmp2[x,y]=float(tmp3)
;                if tmp3 LT tmp[x,y] then tmp2[x,y]=float(tmp3)+2.^16 else tmp2[x,y]=float(tmp3)
;              end
;              2: begin
;                tmp3=ishft(tmp[x,y],2)
;                if tmp3 LT -21536              then tmp2[x,y]=float(tmp3)+2.^16. ; was -11953.8
;                if tmp3 GE -21536 && tmp3 LT 0 then tmp2[x,y]=!values.f_nan
;                if tmp3 GE 0                   then tmp2[x,y]=float(tmp3)
;                if tmp3 LT tmp[x,y] then tmp2[x,y]=float(tmp3)+2.^16 else tmp2[x,y]=float(tmp3)
;              end
;           endcase
;        endfor
;     endfor
     endcase
     
     outimage[*,*,subframe_id]=tmp2

  endfor

  if keyword_set(short) EQ 0 then outimage/=4. ; if long, devide by 4  

end
