pro write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                     refimage_bg,specimage_bg,refimage_n,specimage_n_wc,specimage_n_fc,res_refimage_bg,res_specimage_bg, $
                     mask_refimage,mask_specimage,specmask_n,$
                     imagheader,specheader,imagheader_extract,specheader_extract, $
                     noisemap,noisemap_n,noise_mask, $
                     dir=dir
  common gui,logger

  get_prefix,dir,prefix

; output log
  log=logger->gettext()
  writecol,prefix+'.log',log,fmt='A'

; tweaking headers
  imagheader=imagheader[*,0]
  specheader=specheader[*,0]
  
  imagheader_whole=imagheader & sxdelpar,imagheader_whole,'NAXIS3'
  specheader_whole=specheader & sxdelpar,specheader_whole,'NAXIS3'

;;; Write FITS images

; whole image products
  mwrfits,refimage_bg,prefix+ '.refimage_bg.fits',imagheader_whole,/create
  mwrfits,specimage_bg,prefix+'.specimage_bg.fits',specheader_whole,/create

   if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then return

  mwrfits,res_refimage_bg,prefix+ '.residual_refimage_bg.fits',imagheader_whole,/create
  mwrfits,res_specimage_bg,prefix+'.residual_specimage_bg.fits',imagheader_whole,/create

  mwrfits,mask_refimage,prefix+ '.refimage_mask.fits',imagheader_whole,/create
  mwrfits,mask_specimage,prefix+'.specimage_mask.fits',specheader_whole,/create

  mwrfits,noisemap,prefix+'.specimage_noisemap.fits',specheader_whole,/create
  mwrfits,noise_mask,prefix+'.specimage_noisemask.fits',specheader_whole,/create

; extracted image products
  mwrfits,refimage_n,prefix+    '.refimage_bg_indiv.fits',imagheader,/create
  mwrfits,specimage_n_wc,prefix+'.specimage_wc_indiv.fits',specheader,/create
  mwrfits,specimage_n_fc,prefix+'.specimage_fc_indiv.fits',specheader,/create
  
  mwrfits,specmask_n,prefix+    '.specimage_mask_indiv.fits',specheader,/create

  mwrfits,noisemap_n,prefix+    '.specimage_noisemap_indiv.fits',specheader,/create

;  write (and read) ascii spectra
;  write_spec,wave_array,specimage_fc_1d
;  read_spec,wave_array,specimage_fc_1d

; Write a catalog file
  write_target_table,source_table,prefix=prefix;,dir=dir
  write_source_table,source_table,prefix=prefix;,dir=dir

;  write_profile,space_profile,dir=dir,filename=prefix+'.space1Dprof.dat'
;  write_profile,spec_profile,dir=dir,filename=prefix +'.spec1Dprof.dat'

;  mwrfits,badpixelimage_image,strcompress(prefix+'.badpiximage.fits',/remove_all)
;  mwrfits,badpixelimage_spec,strcompress(prefix+'.badpixspecimage.fits',/remove_all)

; region files
  regionfilename=prefix+'.refimage.reg'
  write_ds9_region_file,source_table,filename=regionfilename,/IMAG
  regionfilename=prefix+'.specimage.reg'
  write_ds9_region_file,source_table,filename=regionfilename

; putwcs
; return
  if ~ LG2() then put_wcs,refimage_bg,imagheader_whole,prefix

end
