PRO write_response,x,y,wave_array,response,d_response

; Write response to a text file
;
; (x,y): position of response measurement
; This is for fitting spatial variation of response.

; read_response and write_response should work consistently.

common dir_structure,datadir,calibdir

dataoutdir=calibdir+'/RESPONSE'

outfilename = DIALOG_PICKFILE (FILTER = '*.dat',title='Response Table Output File Name',path=dataoutdir)

inf_region=where(finite(wave_array,/infinity),count)
if count GT 0 then wave_array[inf_region]=-1.
nan_region=where(finite(wave_array,/NAN),count)
if count GT 0 then wave_array[nan_region]=-1.

inf_region=where(finite(response,/infinity),count)
if count GT 0 then response[inf_region]=-1.
nan_region=where(finite(response,/NAN),count)
if count GT 0 then response[nan_region]=-1.

inf_region=where(finite(d_response,/infinity),count)
if count GT 0 then d_response[inf_region]=-1.
nan_region=where(finite(d_response,/NAN),count)
if count GT 0 then d_response[nan_region]=-1.

GET_LUN,U & openw,U,outfilename

printf,U,x,y; 1st row shows position of response measurement

for i=0,n_elements(response)-1 do printf,U,wave_array[i],response[i] > 0.,d_response[i]

close,U & FREE_LUN,U

END
