PRO write_source_table,source_table,dir=dir,prefix=prefix;, $
;                      targetid=targetid,targetsubid=targetsubid,filter_spec=filter_spec

;  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
;  common frame_type,chip,filter,grism

  if defined(prefix) EQ 0 then get_prefix,dir,prefix
;begin
;  prefix=dir+'/'+string(targetid)+'.'+string(targetsubid)
;   if defined(filter_spec) then prefix=prefix+'.'+filter_spec
;   prefix=strcompress(prefix,/remove_all)
;end
          
;filename = DIALOG_PICKFILE (FILTER = '*.tbl',title='Source Table Output File Name',path=workdir)
  filename=prefix+'.source_table.tbl'

  if defined(source_table) then n_source=n_elements(source_table) else n_source=n_elements(x)

  GET_LUN,U & openw,U,filename
  
  printf,U, $
         'ID, image_x, image_y, image_mask_dx, image_mask_dy, spec_x, spec_y, spec_mask_dx, spec_mask_dy, flux, image_FWHM, spec_bgnoise_ADU, spec_x_pos, spec_x_FWHM, bad_sourcepos_flag'
  
  for source_id=0,n_source-1 do begin
     printf, U,$
             source_table[source_id].ID, $
             source_table[source_id].image_x, $
             source_table[source_id].image_y, $
             source_table[source_id].image_mask_dx, $
             source_table[source_id].image_mask_dy, $
             source_table[source_id].spec_x, $
             source_table[source_id].spec_y, $
             source_table[source_id].spec_mask_dx, $
             source_table[source_id].spec_mask_dy, $
             source_table[source_id].flux, $
             source_table[source_id].image_FWHM, $
             source_table[source_id].spec_bgnoise_ADU, $
             source_table[source_id].spec_x_pos, $
             source_table[source_id].spec_x_FWHM, $
             source_table[source_id].bad_sourcepos_flag,format='(15(A14))'
  endfor
  
  close,U & FREE_LUN,U
  
END
