PRO BROWNIAN

;- Create visible window, and initialize plot
xsize = 640
ysize = 512
window, /free, xsize=xsize, ysize=ysize
viswin = !d.window
plot, [0], /nodata, xrange=[-1, 1], yrange=[-1, 1]

;- Create pixmap window, and copy visible window
window, /free, /pixmap, xsize=xsize, ysize=ysize
pixwin = !d.window
device, copy=[0, 0, xsize, ysize, 0, 0, viswin]

;- Set animation parameters
nframes = 250
npoints = 50
temp = 0.02
seed = -1L
x = randomn(seed, npoints) * 0.1
y = randomn(seed, npoints) * 0.1

;- Create Brownian motion animation in visible window
wset, viswin
for i = 1L, nframes do begin
  device, copy=[0, 0, xsize, ysize, 0, 0, pixwin]
  plots, x, y, psym=1
  x = x + temp * randomn(seed, npoints)
  y = y + temp * randomn(seed, npoints)
endfor

END
