PRO TEST_SWITCH, MONTH, YEAR

;- Compute number of days in month, with correct
;- accounting for leap years.
;- There is a leap year every year divisible by four,
;- except for years which are both divisible by 100
;- and not divisible by 400

switch long(month) of
   1 :
   3 :
   5 :
   7 :
   8 :
  10 :
  12 : begin
    numdays = 31
    break
  end
   4 :
   6 :
   9 :
  11 : begin
    numdays = 30
    break
  end
   2 : begin
    if ((long(year) mod 4L) eq 0L) then begin
      if ((long(year) mod 100L) eq 0L) and $
         ((long(year) mod 400L) ne 0L) then $
        numdays = 28 else numdays = 29
    endif else begin
      numdays = 28
    endelse
    break
  end
  else : message, 'Illegal MONTH'
endswitch

print, numdays, month, year, $
  format='("There are ", i2, " days in month ",' + $
    'i2, " of year ", i6)'

END
