;+
; NAME:
;  mkhtmlog
; PURPOSE: (one line)
;  Generate html looker log for posting from .match file
; DESCRIPTION:
; CATEGORY:
;  Astronomy
; CALLING SEQUENCE:
;  mkhtmlog, matchfile, editor
; INPUTS:
;     matchlist - Name of match file to read (generated by matchup).
;     editor    - Name of person generating this file.
; OPTIONAL INPUT PARAMETERS:
;     CTIO - flag, if true signifies CTIO data (otherwise KPNO assumed)
; KEYWORD INPUT PARAMETERS:
; OUTPUTS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; RESTRICTIONS:
; PROCEDURE:
; MODIFICATION HISTORY:
;  02/08/11, Written by Susan D. Kern, MIT
;  03/08/23, MWB, fixed CTIO date handling
;-
pro mkhtmlog, matchfile, editor, CTIO=CTIO

   if n_params() eq 0 then begin
      doc_library,'mkhtmlog'
      return
   endif

   if badpar(ctio,[0,1,2,3],0,CALLER='MKHTMLOG: (CTIO) ', $
                              default=0) then return

   if not exists(matchfile) then begin
      print,matchfile,' could not be found.  Aborting.'
      return
   endif

   ; read in all object and match information
   m=0
   line=''
   nlines=0
   openr, lun, matchfile, /get_lun

      while not eof(lun) do begin
         readf,lun,line,format='(a1)'
         nlines=nlines+1
      endwhile

      object=strarr(nlines)
      objmatch=strarr(nlines)
      numele=fltarr(nlines)
      len=fltarr(nlines)
      point_lun,lun,0

   for i=0, nlines-1 do begin
      readf,lun,line,format='(a)'
      words = strsplit(line, ' ', /extract)
      object[i] = strtrim(words[0],2)
      objmatch[i] = line
      numele[i]=n_elements(words)-1
      len[i]=strlen(object[i])
   endfor
   free_lun, lun

   nobj=n_elements(object)
   maxlen=FIX(max(len)+1)
   maxlenl=byte(max(len)+1)
   format='('+strcompress(('A'+string(maxlen)), /remove_all)+')'

   for i=0, nobj-1 do begin
      object[i]=strn(object[i], padtype=0, format=format, length=maxlenl)
   endfor

   nmax=max(numele)
   nmaxreal=max(numele)
   if nmax gt 3 then nmax=3

   date=strmid(matchfile,0,6)
   tdate='20'+strmid(date,0,2)+'/'+strmid(date,2,2)+'/'+strmid(date,4,2)
   jdate = jdparse(tdate)
   jdstr, jdate, -118, newdate

   if CTIO then begin
      jdate2 = jdate-1.0d0
      jdstr, jdate2, -118, newdate2

      ; is the year different on the two dates?
      if strmid(newdate,0,4) ne strmid(newdate2,0,4) then begin
         newdate = newdate2+'/'+newdate
      endif else if strmid(newdate,5,3) ne strmid(newdate2,5,3) then begin
         newdate = newdate2+'/'+strmid(newdate,5,6)
      endif else begin
         newdate = newdate2+'/'+strmid(newdate,9,2)
      endelse
   endif

   if ctio then telstr='CTIO' else telstr='KPNO'

   outfile='look'+date+'.html'
   ; Save results to output file.
   openw,lun,outfile,/get_lun

   ; Put in html code for beginning of file
   printf, lun, '<html>'
   printf, lun, ' '
   printf, lun, '<head>'
   printf, lun, '<title>KBO Searching Status for ',telstr,' 4-m observing, ', $
                newdate, '</title>'
   printf, lun, '</head>'
   printf, lun, ' '
   printf, lun, '<body>'
   printf, lun, '<h1>Visual searching status -- ',newdate, '</h1>'
   printf, lun, ' '
   printf, lun, '<p>'
   printf, lun, 'Please familiarize yourself with the'
   printf, lun, '<a href=''lookerguide.html''>guidelines</a>'
   printf, lun, 'for running LOOKER.'
   printf, lun, '</p>'
   printf, lun, ' '
   printf, lun,'<table border=1>'
   printf, lun,'<tr>'
   printf, lun,'<td>Object</td>'
   printf, lun,'<td>A</td>'
   printf, lun,'<td>B</td>'
   if nmax eq 3 then printf, lun,'<td>C</td>'
   printf, lun,'<td>Pass 1</td>'
   printf, lun,'<td>Pass 2</td>'
   printf, lun,'<td>x1</td>'
   printf, lun,'<td>x2</td>'
   printf, lun,'<td>x3</td>'
   printf, lun,'<td>x4</td>'
   printf, lun,'<td>x5</td>'
   printf, lun,'<td>x6</td>'
   printf, lun,'<td>x7</td>'
   printf, lun,'<td>x8</td>'
   printf, lun,'<td>Comments-------------------</td>'
   printf, lun,'</tr>'

   value=strarr(nlines)
   printline=''
   
   for i=0,nobj-1 do begin
      match = strsplit(objmatch[i], ' ', /extract)

      if nmaxreal gt 3 then begin
         
         maxlen=FIX((nmaxreal-2)*3+(nmaxreal-2)+5)
         maxlenl=byte(maxlen+1)
         format='('+strcompress(('A'+string(maxlen)), /remove_all)+')'
            if numele[i] eq 2 then begin
               input='&nbsp'
               value[i]=strn(input, padtype=1, format=format, length=maxlenl)
            endif
            if numele[i] eq 3 then begin
               input=strmid(match[3],7,3)+'&nbsp'
               value[i]=strn(input, padtype=1, format=format, length=maxlenl)
            endif
            if numele[i] eq 4 then begin
               input=strmid(match[3],7,3)+'/'+strmid(match[4],7,3)+'&nbsp'
               value[i]=strn(input, padtype=1, format=format, length=maxlenl)
            endif
            if numele[i] eq 5 then begin
               input=strmid(match[3],7,3)+'/'+ $
                     strmid(match[4],7,3)+'/'+ $
                     strmid(match[5],7,3)+'&nbsp'
               value[i]=strn(input, padtype=1, format=format, length=maxlenl)
            endif
      endif

      if nmax eq 2 and numele[i] eq 2 then begin
          printline='<tr><td>'+object[i]+ $
             ' </td><td>'+strmid(match[1],7,3)+ $
             '</td><td>'+strmid(match[2],7,3)+ $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;'+ $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;'+ $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;'+ $
             '</td><td>&nbsp;</td><td>&nbsp;</td></tr>'

          printf,lun,printline, format='(a)'
      endif

      if nmax eq 3 and numele[i] eq 2 then begin
          input='&nbsp'
          value[i]=strn(input, padtype=1, format=format, length=maxlenl)

          printline='<tr><td>'+object[i]+ $
             ' </td><td>'+strmid(match[1],7,3)+ $
             '</td><td>'+strmid(match[2],7,3) + $
             '</td><td>'+value[i]+ $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;' + $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;' + $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;' + $
             '</td><td>&nbsp;</td><td>&nbsp;</td></tr>'

         printf,lun,printline, format='(a)'
      endif
      
      if nmax eq 3 and numele[i] eq 3 then begin
             input=strmid(match[3],7,3)+'&nbsp'
             value[i]=strn(input, padtype=1, format=format, length=maxlenl)

          printline='<tr><td>'+object[i]+ $
             ' </td><td>'+strmid(match[1],7,3)+ $
             '</td><td>'+strmid(match[2],7,3) + $
             '</td><td>'+value[i]+ $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;' + $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;' + $
             '</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;' + $
             '</td><td>&nbsp;</td><td>&nbsp;</td></tr>'

         printf,lun,printline, format='(a)'

      endif

   endfor

   printf, lun,' '
   printf, lun,'</table>'
   printf, lun,'<p> Uppercase name means field has been assigned but search'
   printf, lun,'is not completed.  When the search is completed, the initials'
   printf, lun,'will change to lower case.'
   printf, lun,'</body>'
   printf, lun,' '

   updatetime=systime()
   printf, lun,'<p>'
   printf, lun,'<address>Last updated ', updatetime, ' by ', editor,'</address>'
   printf, lun,' '

   printf, lun,'</html>'

   free_lun,lun

end
