; ----------------------------------------------------------------------------
;+
; NAME:
;     DRAW_RECTANGLE (procedure)
;
; PURPOSE:
;     Draw a rectangle centered at (cx, cy) of width w and height h 
;
; CALLING SEQUENCE:
;     DRAW_RECTANGLE, cx, cy, w, h [, c]
;
; INPUTS:
;     cx : x center point of rectangle
;     cy : y center point of rectangle
;     w  : width of rectangle
;     h  : height of rectangle
;     c  : optional color index (D = !P.COLOR) 
;
; KEYWORDS:
;
;     COLOR : Specify a color index (D = !P.COLOR)
;
;     FILL  : Draw a filled polygon; if this keyword is set, any valid 
;             POLYFILL keyword may also be used
;
; COMMON BLOCKS:
;     NONE
;
; SIDE EFFECTS:
;     None known
;
; RESTRICTIONS:
;     None known
;
; DEPENDENCIES:
;     NONE
;
; MODIFICATION HISTORY:
;     Written, 1999 August, Robert.Mallozzi@msfc.nasa.gov
;
;-
; ----------------------------------------------------------------------------

PRO DRAW_RECTANGLE, cx, cy, w, h, COLOR = color, FILL = fill, _EXTRA = extra
on_error,2
    IF (N_ELEMENTS (color) EQ 0) THEN $
       color = !P.COLOR

    x = DBLARR (5)
    y = DBLARR (5)

    hw = w / 2.0d
    hh = h / 2.0d

    x[0] = cx - hw
    x[1] = cx - hw
    x[2] = cx + hw
    x[3] = cx + hw
    x[4] = cx - hw

    y[0] = cy - hh
    y[1] = cy + hh
    y[2] = cy + hh
    y[3] = cy - hh
    y[4] = cy - hh

    PLOTS, x, y, COLOR = color,  _EXTRA = extra
; _EXTRA = extra added by YO
    IF (KEYWORD_SET (fill)) THEN $
       POLYFILL, x, y, _EXTRA = extra
END
