PRO adgain

ncolor_plot=6
white  = GetColor('white',  !D.Table_Size-(ncolor_plot-5))
yellow = GetColor('yellow', !D.Table_Size-(ncolor_plot-4))
red    = GetColor('red',    !D.Table_Size-(ncolor_plot-3))
green  = GetColor('green',  !D.Table_Size-(ncolor_plot-2))

ncol_nir = 412L ; X
nrow_nir = 512L ; Y
ncol_mir = 256L ; X
nrow_mir = 512L ; Y

; NIR settings
frame_id_max=1; for NIR; 3 for MIRs
f_factor=4.; factor 4 for NIR counts
; MIR settings
frame_id_max=3; for NIR; 3 for MIRs
f_factor=1.; factor 4 for NIR counts

meanvalue=fltarr(ncol_mir^2*12*frame_id_max)
rmsvalue=fltarr(ncol_mir^2*12*frame_id_max)

;
; dark read
;
filename = DIALOG_PICKFILE (FILTER = '*.lst',title='Input a file of darks')
irc_list_fits_read,filename,NIR_darks,MIRS_darks,MIRL_darks,n_nir,n_mir
;
; Sets of 11 files read
;
irc_listread,list,num

;imagelist='/home/ohyama/FECs/FEC5/TEMP_DARK/temp_dark_min2.lst'
;imagelist='/home/ohyama/FECs/FEC5/TEMP_DARK/temp_dark.lst'
;cd,       '/home/ohyama/FECs/FEC5/TEMP_DARK'
cd,       '/home/ohyama/FECs/FEC7/050214_1640'


l=0L
for frame_id=1,frame_id_max do begin
    for p=0,num-1 do begin
        print,list[p]
        irc_list_fits_read,list[p],NIR_image,MIRS_image,MIRL_image,n_nir,n_mir

        NIR_IMAGE=NIR_IMAGE/f_factor  ;correction for multiple sampling
        MIRS_IMAGE=MIRS_IMAGE-MIRS_DARKS
        MIRL_IMAGE=MIRL_IMAGE-MIRL_DARKS
        NIR_IMAGE=NIR_IMAGE-NIR_DARKS

;       irc_make_rmsimage,NIR_Image[*,*,frame_id,*],rmsimage
;       irc_make_avgimage,NIR_Image[*,*,frame_id,*],avgimage

;        irc_make_rmsimage,MIRS_Image[*,*,frame_id,*],rmsimage
;        irc_make_avgimage,MIRS_Image[*,*,frame_id,*],avgimage

       irc_make_rmsimage,MIRL_Image[*,*,frame_id,*],rmsimage
       irc_make_avgimage,MIRL_Image[*,*,frame_id,*],avgimage


;    atv,outimage,/block
        print,median(rmsimage),median(avgimage)
        
        for j=0,ncol_mir-1 do begin
            for k=0,ncol_mir-1 do begin
                meanvalue[l]=avgimage[j,k]
                rmsvalue[l]=rmsimage[j,k]
                l=l+1
            endfor
        endfor
    endfor
endfor

varvalue=rmsvalue^2
;plot,meanvalue,varvalue,psym=3,xrange=[0,25000],yrange=[0,10000]

message,'Finish'

range=where(meanvalue LT 25000/f_factor and varvalue LT 25000/f_factor)

;coef=robust_linefit(meanvalue[range],varvalue[range])
coef=poly_fit(meanvalue[range],varvalue[range],1,sigma=sigma)

oplot,findgen(25000)*coef[1]+coef[0],color=red
print,1./coef[1],sqrt(coef[0])/coef[1]
print,1./coef[1]^2.*sigma[1],$
  sqrt($
        ((0.5*coef[0]^(-0.5)/coef[1]*sigma[0])^2.)+$
        (((sqrt(coef[0])/coef[1]^2.)*sigma[1])^2.)$
      )

mydevice = !D.NAME
SET_PLOT, 'PS'
;DEVICE, FILENAME='adgain_NIR.ps', /LANDSCAPE,/color
;DEVICE, FILENAME='adgain_MIRS.ps', /LANDSCAPE,/color
DEVICE, FILENAME='adgain_MIRL.ps', /LANDSCAPE,/color

plot,meanvalue,varvalue,psym=3,xrange=[0,25000/f_factor],yrange=[0,10000/f_factor]
oplot,findgen(25000/f_factor)*coef[1]+coef[0],color=red

DEVICE, /CLOSE               ; Return plotting to the original device:
SET_PLOT, mydevice


END
