pro calc_np_distortion_grid,specimage_wc,source_table,coef

COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

;
; This is only for preflight grid data
;

make_diff_specimage,specimage_wc,aho

s=size(aho) & xsize=s[1] & n_source=s[2]
xarray=findgen(xsize)
edge_pos=fltarr(n_source)
use_array=intarr(n_source)
use_flag=intarr(n_source)

window,xsize=500,ysize=500

k=0
for source_id=0,n_source-1 do begin
    plot,aho[*,source_id],psym=10,color=white,yrange=[-0.3,0.3],xrange=[2,15]
    result=gaussfit(xarray[2:15],aho[2:15,source_id],A,nterms=5)
    oplot,xarray[2:15],result,color=red
    edge_pos[source_id]=a[1]
    if source_table[source_id].spec_y + (source_table[source_id].spec_mask_dy-1)/2 LT 411 and a[0] GT 0.1 then begin
        use_array[k]=source_id
        use_flag[source_id]=1
        k=k+1
    endif
    wait,0.3
endfor

use_array=use_array[0:k-1]
n_data=k

coef=rob_quarticfit(double(source_table[use_array].spec_x), $
                    double(source_table[use_array].spec_y), $
                    edge_pos[use_array], $
                    fit,sig)
print,edge_pos[use_array]-fit

plot,source_table[use_array].spec_y,fit,psym=4,color=white,/ynozero
oplot,source_table[use_array].spec_y,edge_pos[use_array],psym=5,color=red

;plot,source_table[use_array].spec_x,fit-edge_pos[use_array],psym=4,color=white,/ynozero

for i=0,n_data-1 do begin
    boxyoffset $
      =coef[0] $
      +coef[1]*double((source_table[use_array[i]].spec_x)) $
      +coef[2]*double((source_table[use_array[i]].spec_x))^2. $
      +coef[4]*double((source_table[use_array[i]].spec_y)) $
      +coef[5]*double((source_table[use_array[i]].spec_y))^2. $
      +coef[3]*double((source_table[use_array[i]].spec_x))*double((source_table[use_array[i]].spec_y))

;    source_table[source_id].spec_y=source_table[source_id].spec_y-boxyoffset
;    print,boxyoffset,edge_pos[i],boxyoffset-edge_pos[i],use_flag[i]
endfor

print,'Fitting sigma = ',sig
coef[0]=coef[0]-median(fit)

end
