pro calc_sg2_distortion,specimage_wc,source_table,coef
COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

make_diff_specimage,specimage_wc,aho
s=size(aho)
xsize=s[1]
n_source=s[2]
xarray=findgen(xsize)
edge_pos=fltarr(n_source)
use_array=intarr(n_source)

window,xsize=500,ysize=500

k=0
for source_id=0,n_source-1 do begin
    if source_table[source_id].spec_y - (source_table[source_id].spec_mask_dy-1)/2 GT 0 then begin
        use_array[k]=source_id
        print,'OK',source_id
        k=k+1
    endif
    plot,aho[*,source_id],psym=10,color=white,yrange=[-0.3,0.3],xrange=[5,13],xstyle=1
    result=gaussfit(xarray[5:13],aho[5:13,source_id],A,nterms=5)
    oplot,xarray[5:13],result,color=red
    edge_pos[source_id]=a[1]
    wait,0.3
endfor

use_array=use_array[0:k-1]

coef=rob_quarticfit(double(source_table[use_array].spec_x), $
                    double(source_table[use_array].spec_y), $
                    edge_pos[use_array], $
                    fit,sig)

plot,source_table[use_array].spec_y,fit,psym=4,color=white,/ynozero
oplot,source_table[use_array].spec_y,edge_pos[use_array],psym=5,color=red

;plot,source_table[use_array].spec_x,fit-edge_pos[use_array],psym=4,color=white,/ynozero,yrange=[0,3]

print,'Fitting sigma = ',sig
coef[0]=coef[0]-median(fit)

end
