pro calc_specresponse,wave_array,spec1d_wc,d_spec1d_wc,response,d_response

; common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
; common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

; Make a spec-response curve
; Response and its estimated error (d_response) will be calculated,
; based on measured noise in ADU and Cohen star's flux error.

  response=fltarr(n_elements(spec1d_wc)) & d_response=fltarr(n_elements(spec1d_wc))

; select and read cohen data file
  fileName = DIALOG_PICKFILE (PATH=!IRC_SPECRED_DIR.calibdir+'StdSpecData/', FILTER = '*.tem',title='COHEN STD Stars')
  read_cohen,cohen_lambda,cohen_flux,cohen_d_flux,count,filename

  bin_cohen_spec,cohen_lambda,cohen_flux,cohen_d_flux,wave_array,cohen_flux_bin,cohen_d_flux_bin

  n_wave=n_elements(wave_array)
  for i=1,n_wave-1-1 do begin
     response[i]=spec1d_wc[i]/cohen_flux_bin[i]
     d_response[i]=sqrt((1./cohen_flux_bin[i]*d_spec1d_wc[i])^2. $
                        +(spec1d_wc[i]/cohen_flux_bin[i]^2.*cohen_d_flux_bin[i])^2.)
     if response[i] LT d_response[i] then begin ; when data is noisy, force it to zero.
        response[i]=-1. & d_response[i]=-1.
        continue
     endif
  endfor
  
; check the performance of the interporation
; plot,cohen_lambda,cohen_flux,psym=1,xrange=[5,9]
; oplot,wave_array,cohen_flux_bin,psym=7,color=!IRC_SPECRED_COLOR.red
  
; plot,cohen_lambda,cohen_d_flux,psym=1,xrange=[5,9]
; oplot,wave_array,cohen_d_flux_bin,psym=7,color=!IRC_SPECRED_COLOT.red
  
end
