function flat1d,image2d
;output=total(image2d,1)
dim=size(image2d)
xdim=dim[1] & ydim=dim[2]

output=fltarr(ydim)
;for i=0,ydim-1 do output[i]=median(image2d[*,i])
for i=0,ydim-1 do output[i]=meanclip_func(image2d[*,i],3)

;output=total(image2d[0:xdim-1,*],1)
return,output
end

PRO calc_specslitflat

COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
set_color

; file read
irc_fits_read,image,header,dir='/home/ohyama/FECs/SougouSiken/All_Filters/'

params=dialog_menu(['NP','NG','SG1','SG2','LG1','LG2'],title='Disperser Selection')

case params of
    'NP':begin                ;for innter wide slit for diffuse source
        x1=0 & x2=411
        y1=394 & y2=425
    end
    
    'NG':begin
        x1=0 & x2=411
        y1=389 & y2=418
    end
    
    'SG1':begin
        x1=10 & x2=18
        y1=0 & y2=255
    end
    
    'SG2':begin
        x1=10 & x2=18
        y1=0 & y2=255

    end

    'LG1':begin
        x1=245 & x2=255
        y1=255+103 & y2=255+103+64

    end

    'LG2':begin
        x1=245 & x2=255
        y1=255+103 & y2=255+103+64
    end

endcase

image2=image[x1:x2,y1:y2,1]
atv,image2,/block

if params EQ 'NP' or params EQ 'NG' then image3=rotate(image2[*,*],1) else image3=image2[*,*]

image_1d=flat1d(image3)
;image_1d=total(image3,1)

plot,image_1d,xrange=[0,n_elements(image_1d)],xstyle=1,/ynozero,psym=10


message,'Finish'

END
