PRO firstframeeffect

ncolor_plot=6

white  = GetColor('white',  !D.Table_Size-(ncolor_plot-5))
yellow = GetColor('yellow', !D.Table_Size-(ncolor_plot-4))
red    = GetColor('red',    !D.Table_Size-(ncolor_plot-3))
green  = GetColor('green',  !D.Table_Size-(ncolor_plot-2))

;imagelist='/home/ohyama/FECs/FEC6/050106/shorterdark.lst'
;imagelist='/home/ohyama/FECs/FEC6/050106/longdark.lst'

;imagelist='/home/ohyama/FECs/FEC6/050106/contall3.lst'
;cd,       '/home/ohyama/FECs/FEC6/050106/'

;imagelist='/home/ohyama/FECs/FEC7/050214_1640/dark_cal3.lst'
;cd,       '/home/ohyama/FECs/FEC7/050214_1640/'

imagelist='/home/ohyama/FECs/TVT/051006_0/CAL_DARK_8s_NO.lst'
cd,'/home/ohyama/FECs/TVT/051006_0/'

irc_list_fits_read,imagelist,NIR_image, MIRS_image,MIRL_image,n_nir,n_mir

ncol_nir = 412L ; X
nrow_nir = 512L ; Y
ncol_mir = 256L ; X
nrow_mir = 512L ; Y

message,'Finish'

;0-11 dark
;12-23 cal1
;24-35 cal2
;36-47 cal3
;48-59 dark

;
; Plots for CAL_DARK_CAL seq.
;

mydevice = !D.NAME
SET_PLOT, 'PS'
;DEVICE, FILENAME='~/1steffect_dark_gain.ps', /LANDSCAPE,/color
DEVICE, FILENAME='dark_cal2.ps', /LANDSCAPE,/color

DEVICE, /CLOSE ; Return plotting to the original device:
SET_PLOT, mydevice


plot,mirs_image[100,50,1,*],psym=4,yrange=[0,200]; MIR-S
plot,mirs_image[100,50,1,*],psym=4,yrange=[0,1000]; MIR-L

n=n_elements(mirs_image[0,0,0,*])
mean_mirs=fltarr(n*4)

for j=0,n*4-1 do mean_mirs[j]=mean(mirs_image[100:110,50:60,j mod 4,fix(j/4)])

plot,mean_mirs,psym=5,yrange=[70,200],color=white

plot,nir_image[100,100,1,*],psym=2,yrange=[-100,500]

plot,mirs_image[100,100,0,*],psym=4,yrange=[0,80]
plot,mirs_image[100,300,0,*],psym=4,yrange=[0,80]
plot,nir_image[100,100,1,*],psym=2,yrange=[-30,30]

; count vs. gain
plot,mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],(mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0])/(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0]),psym=3,xrange=[0,5e3],yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0])/(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0]),psym=3,color=green
oplot,mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0]),psym=3,color=yellow

plot,mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0],(mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0])/(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0]),psym=3,xrange=[0,2.5e4],yrange=[0.90,1.10],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0],(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0])/(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0]),psym=3,color=green
oplot,mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0],(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0])/(mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0]),psym=3,color=yellow

; bias vs. gain
plot,mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,12]-mirs_image[*,0:235,1,0])/(mirs_image[*,0:235,2,12]-mirs_image[*,0:235,2,0]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,200]
oplot,mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,12]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,3,12]-mirs_image[*,0:235,3,0]),psym=3,color=yellow
oplot,mirs_image[*,0:235,3,0],(mirs_image[*,0:235,3,12]-mirs_image[*,0:235,3,0])/(mirs_image[*,0:235,2,12]-mirs_image[*,0:235,2,1]),psym=3,color=red

plot,mirs_image[*,0:235,1,48],(mirs_image[*,0:235,1,12]-mirs_image[*,0:235,1,48])/(mirs_image[*,0:235,1,13]-mirs_image[*,0:235,1,49]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,200]
oplot,mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,12]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,3,12]-mirs_image[*,0:235,3,0]),psym=3,color=yellow
oplot,mirs_image[*,0:235,3,0],(mirs_image[*,0:235,3,12]-mirs_image[*,0:235,3,0])/(mirs_image[*,0:235,2,12]-mirs_image[*,0:235,2,1]),psym=3,color=red

plot,(mirs_image[*,0:235,1,12]-mirs_image[*,0:235,1,48])/(mirs_image[*,0:235,1,13]-mirs_image[*,0:235,1,49]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,200]
oplot,(mirs_image[*,0:235,1,12]-mirs_image[*,0:235,1,48])/(mirs_image[*,0:235,2,12]-mirs_image[*,0:235,2,48]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,200]

plot,mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0])/(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,200]
oplot,mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0]),psym=3,color=yellow
oplot,mirs_image[*,0:235,3,0],(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0])/(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,1]),psym=3,color=red


mydevice = !D.NAME
SET_PLOT, 'PS'
DEVICE, FILENAME='~/1steffect_dark_gain_tvt.ps', /LANDSCAPE,/color
;DEVICE, FILENAME='dark_cal2.ps', /LANDSCAPE,/color

; for TVT
 plot,mirs_image[130:170,235:254,1,6],(mirs_image[130:170,235:254,1,0]-mirs_image[130:170,235:254,1,6])/(mirs_image[130:170,235:254,3,5]-mirs_image[130:170,235:254,3,11]),psym=3,xrange=[0,200],yrange=[0.90,1.10]
oplot,mirs_image[130:170,235:254,2,6],(mirs_image[130:170,235:254,2,0]-mirs_image[130:170,235:254,2,6])/(mirs_image[130:170,235:254,3,5]-mirs_image[130:170,235:254,3,11]),psym=3,color=green
oplot,mirs_image[130:170,235:254,3,6],(mirs_image[130:170,235:254,3,0]-mirs_image[130:170,235:254,3,6])/(mirs_image[130:170,235:254,3,5]-mirs_image[130:170,235:254,3,11]),psym=3,color=red

DEVICE, /CLOSE ; Return plotting to the original device:
SET_PLOT, mydevice


; ATVs for checking 1st frame effect
;

atv,(mirs_image[*,*,1,12]-mirs_image[*,*,1,0])/(mirs_image[*,*,1,13]-mirs_image[*,*,1,1]),/block; flat, less than unit, 
atv,(mirs_image[*,*,2,12]-mirs_image[*,*,2,0])/(mirs_image[*,*,3,12]-mirs_image[*,*,3,0]),/block; flat, less than unit, 
atv,(mirs_image[*,*,1,24]-mirs_image[*,*,1,0])/(mirs_image[*,*,2,24]-mirs_image[*,*,2,0]),/block; flat, less than unit, 
atv,(mirs_image[*,*,1,12]-mirs_image[*,*,1,0])/(mirs_image[*,*,1,13]-mirs_image[*,*,1,1]),/block; flat, less than unit, 
atv,(mirs_image[*,*,1,24]-mirs_image[*,*,1,48])/(mirs_image[*,*,2,24]-mirs_image[*,*,2,48]),/block; flat, less than unit, 
atv,(mirs_image[*,*,1,12]-mirs_image[*,*,1,48])/(mirs_image[*,*,1,13]-mirs_image[*,*,1,49]),/block; flat, less than unit, 

atv,(mirs_image[*,*,1,25]-mirs_image[*,*,1,1])-(mirs_image[*,*,2,24]-mirs_image[*,*,2,0]),/block
atv,(mirs_image[*,*,0,25]-mirs_image[*,*,0,1])/(mirs_image[*,*,1,25]-mirs_image[*,*,1,1]),/block;
atv,mirs_image[*,*,0,0]-mirs_image[*,*,1,0],/block; flat, but non zero (positive)
atv,mirs_image[*,*,1,0]-mirs_image[*,*,2,0],/block; flat, closer to zero, but non zero
atv,mirs_image[*,*,2,0]-mirs_image[*,*,3,0],/block; flat, much closer to zero
atv,mirs_image[*,*,3,0]-mirs_image[*,*,2,1],/block
atv,mirs_image[*,*,0,24]-mirs_image[*,*,1,24],/block; residual pattern
atv,mirs_image[*,*,0,24]/mirs_image[*,*,1,24],/block; residual pattern
atv,(mirs_image[*,*,0,24]-mirs_image[*,*,3,23])/(mirs_image[*,*,0,24]-mirs_image[*,*,0,0]),/block


for j=0,254 do plot,(mirs_image[j,0:235,1,12]-mirs_image[j,0:235,1,48])/(mirs_image[j,0:235,2,12]-mirs_image[j,0:235,2,48]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,255]
for j=0,254 do plot,(mirs_image[j,0:235,1,24]-mirs_image[j,0:235,1,48])/(mirs_image[j,0:235,2,24]-mirs_image[j,0:235,2,48]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,255]


;0:23 dark
;24- cal1
;48- cal2
;72- dark2

;
; Plots for CAL_DARK_CAL seq.
;

mydevice = !D.NAME
SET_PLOT, 'PS'
;DEVICE, FILENAME='~/1steffect_dark_gain.ps', /LANDSCAPE,/color
DEVICE, FILENAME='dark_cal2.ps', /LANDSCAPE,/color

DEVICE, /CLOSE ; Return plotting to the original device:
SET_PLOT, mydevice


plot,mirs_image[100,100,0,*],psym=4,yrange=[0,1500]; MIR-S
plot,mirs_image[100,300,0,*],psym=4,yrange=[0,100]; MIR-L

plot,nir_image[100,100,1,*],psym=2,yrange=[-100,500]

plot,mirs_image[100,100,0,*],psym=4,yrange=[0,80]
plot,mirs_image[100,300,0,*],psym=4,yrange=[0,80]
plot,nir_image[100,100,1,*],psym=2,yrange=[-30,30]

window,xsize=600,ysize=600
plot,mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],mirs_image[*,0:235,0,24]/mirs_image[*,0:235,0,0],psym=3,xrange=[100,5000],yrange=[1,100],/ylog,/xlog,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],mirs_image[*,0:235,1,24]/mirs_image[*,0:235,1,0],psym=3,color=green
oplot,mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],mirs_image[*,0:235,2,24]/mirs_image[*,0:235,2,0],psym=3,color=yellow
oplot,mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0],mirs_image[*,0:235,3,24]/mirs_image[*,0:235,3,0],psym=3,color=red
;oplot,mirs_image[*,0:235,2,25]-mirs_image[*,0:235,2,1],mirs_image[*,0:235,3,25]/mirs_image[*,0:235,0,1],psym=3
;oplot,mirs_image[*,0:235,3,25]-mirs_image[*,0:235,3,1],mirs_image[*,0:235,3,25]/mirs_image[*,0:235,1,1],psym=3

plot,mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],(mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0])/mirs_image[*,0:235,0,0],psym=3,xrange=[100,5000],yrange=[1,100],/ylog,/xlog,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0])/mirs_image[*,0:235,1,0],psym=3,color=green
oplot,mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0])/mirs_image[*,0:235,2,0],psym=3,color=yellow
oplot,mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0],(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0])/mirs_image[*,0:235,3,0],psym=3,color=red
;oplot,mirs_image[*,0:235,2,25]-mirs_image[*,0:235,2,1],mirs_image[*,0:235,3,25]/mirs_image[*,0:235,0,1],psym=3
;oplot,mirs_image[*,0:235,3,25]-mirs_image[*,0:235,3,1],mirs_image[*,0:235,3,25]/mirs_image[*,0:235,1,1],psym=3

plot,mirs_image[*,0:235,0,72],mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],psym=3,xrange=[00,300],yrange=[0,5000],xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,0:235,1,72],mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],psym=3,color=green
oplot,mirs_image[*,0:235,2,72],mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],psym=3,color=yellow
oplot,mirs_image[*,0:235,3,72],mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0],psym=3,color=red

plot,mirs_image[*,0:235,0,72]-mirs_image[*,0:235,0,0],mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],psym=3,xrange=[-30,30],yrange=[0,5000],xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,0:235,1,72]-mirs_image[*,0:235,1,0],mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],psym=3,color=green
oplot,mirs_image[*,0:235,2,72]-mirs_image[*,0:235,2,0],mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],psym=3,color=yellow
oplot,mirs_image[*,0:235,3,72]-mirs_image[*,0:235,3,0],mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0],psym=3,color=red

plot,mirs_image[*,256:511,0,72]-mirs_image[*,256:511,0,0],mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0],psym=3,xrange=[-30,30],yrange=[0,25000],xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,256:511,1,72]-mirs_image[*,256:511,1,0],mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0],psym=3,color=green
oplot,mirs_image[*,256:511,2,72]-mirs_image[*,256:511,2,0],mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0],psym=3,color=yellow
oplot,mirs_image[*,256:511,3,72]-mirs_image[*,256:511,3,0],mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0],psym=3,color=red

plot,mirs_image[100:110,100:110,0,24]-mirs_image[100:110,100:110,0,0],mirs_image[100:110,100:110,0,24]/mirs_image[100:110,100:110,0,0],psym=3,xrange=[0,2000],yrange=[0,40]
oplot,mirs_image[100:110,100:110,1,24]-mirs_image[100:110,100:110,1,0],mirs_image[100:110,100:110,1,24]/mirs_image[100:110,100:110,1,0],psym=4
oplot,mirs_image[100:110,100:110,2,24]-mirs_image[100:110,100:110,2,0],mirs_image[100:110,100:110,2,24]/mirs_image[100:110,100:110,2,0],psym=5
oplot,mirs_image[100:110,100:110,3,24]-mirs_image[100:110,100:110,3,0],mirs_image[100:110,100:110,3,24]/mirs_image[100:110,100:110,3,0],psym=6
oplot,mirs_image[100:110,100:110,2,25]-mirs_image[100:110,100:110,2,1],mirs_image[100:110,100:110,3,25]/mirs_image[100:110,100:110,0,1],psym=3
oplot,mirs_image[100:110,100:110,3,25]-mirs_image[100:110,100:110,3,1],mirs_image[100:110,100:110,3,25]/mirs_image[100:110,100:110,1,1],psym=3

window,xsize=500,ysize=500
plot,mirs_image[100:110,100:110,0,24]-mirs_image[100:110,100:110,0,0],mirs_image[100:110,100:110,1,24]-mirs_image[100:110,100:110,1,0],psym=3,/ynozero,xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[100:110,100:110,1,24]-mirs_image[100:110,100:110,1,0],mirs_image[100:110,100:110,2,24]-mirs_image[100:110,100:110,2,0],psym=4

; count vs. gain
plot,mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],(mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0])/(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0]),psym=3,xrange=[0,5e3],yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0])/(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0]),psym=3,color=green
oplot,mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0]),psym=3,color=yellow

plot,mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0],(mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0])/(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0]),psym=3,xrange=[0,2.5e4],yrange=[0.95,1.05],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5]
oplot,mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0],(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0])/(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0]),psym=3,color=green
oplot,mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0],(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0])/(mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0]),psym=3,color=yellow

; bias vs. gain
plot,mirs_image[*,0:235,0,0],(mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0])/(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,200]
oplot,mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0])/(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0]),psym=3,color=green
oplot,mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0]),psym=3,color=yellow
oplot,mirs_image[*,0:235,3,0],(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0])/(mirs_image[*,0:235,2,25]-mirs_image[*,0:235,2,1]),psym=3,color=red
;oplot,mirs_image[*,0:235,2,1],(mirs_image[*,0:235,2,25]-mirs_image[*,0:235,2,1])/(mirs_image[*,0:235,3,25]-mirs_image[*,0:235,3,1]),psym=7,color=white,symsize=1
;oplot,mirs_image[*,0:235,3,1],(mirs_image[*,0:235,3,25]-mirs_image[*,0:235,3,1])/(mirs_image[*,0:235,0,26]-mirs_image[*,0:235,0,2]),psym=7,color=green,symsize=1

plot,mirs_image[*,256:511,0,0],(mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0])/(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0]),psym=3,yrange=[0.95,1.05],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,100]
oplot,mirs_image[*,256:511,1,0],(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0])/(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0]),psym=3,color=green
oplot,mirs_image[*,256:511,2,0],(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0])/(mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0]),psym=3,color=yellow
oplot,mirs_image[*,256:511,3,0],(mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0])/(mirs_image[*,256:511,2,25]-mirs_image[*,256:511,2,1]),psym=3,color=red
;oplot,mirs_image[*,256:511,2,1],(mirs_image[*,256:511,2,25]-mirs_image[*,256:511,2,1])/(mirs_image[*,256:511,3,25]-mirs_image[*,256:511,3,1]),psym=7,color=white,symsize=1
;oplot,mirs_image[*,256:511,3,1],(mirs_image[*,256:511,3,25]-mirs_image[*,256:511,3,1])/(mirs_image[*,256:511,0,26]-mirs_image[*,256:511,0,2]),psym=7,color=green,symsize=1

plot,mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0],(mirs_image[*,0:235,0,24]-mirs_image[*,0:235,0,0])/(mirs_image[*,0:235,0,48]-mirs_image[*,0:235,0,0]),psym=3;,yrange=[0,4000],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,5000]
oplot,mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0],(mirs_image[*,0:235,1,24]-mirs_image[*,0:235,1,0])/(mirs_image[*,0:235,1,48]-mirs_image[*,0:235,1,0]),psym=3,color=green
oplot,mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0],(mirs_image[*,0:235,2,24]-mirs_image[*,0:235,2,0])/(mirs_image[*,0:235,2,48]-mirs_image[*,0:235,2,0]),psym=3,color=yellow
oplot,mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0],(mirs_image[*,0:235,3,24]-mirs_image[*,0:235,3,0])/(mirs_image[*,0:235,3,48]-mirs_image[*,0:235,3,0]),psym=3,color=red

plot,mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0],(mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0])/(mirs_image[*,256:511,0,48]-mirs_image[*,256:511,0,0]),psym=3,yrange=[0,400],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,30000]
oplot,mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0],(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0])/(mirs_image[*,256:511,1,48]-mirs_image[*,256:511,1,0]),psym=3,color=green
oplot,mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0],(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0])/(mirs_image[*,256:511,2,48]-mirs_image[*,256:511,2,0]),psym=3,color=yellow
oplot,mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0],(mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0])/(mirs_image[*,256:511,3,48]-mirs_image[*,256:511,3,0]),psym=3,color=red

plot,mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0],(mirs_image[*,256:511,0,24]-mirs_image[*,256:511,0,0])/(mirs_image[*,256:511,0,48]-mirs_image[*,256:511,0,0])/((mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0])/(mirs_image[*,256:511,1,48]-mirs_image[*,256:511,1,0])),psym=3,yrange=[0.,2],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,30000]
oplot,mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0],(mirs_image[*,256:511,1,24]-mirs_image[*,256:511,1,0])/(mirs_image[*,256:511,1,48]-mirs_image[*,256:511,1,0])/((mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0])/(mirs_image[*,256:511,2,48]-mirs_image[*,256:511,2,0])),psym=3,color=green
oplot,mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0],(mirs_image[*,256:511,2,24]-mirs_image[*,256:511,2,0])/(mirs_image[*,256:511,2,48]-mirs_image[*,256:511,2,0]),psym=3,color=yellow
oplot,mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0],(mirs_image[*,256:511,3,24]-mirs_image[*,256:511,3,0])/(mirs_image[*,256:511,3,48]-mirs_image[*,256:511,3,0]),psym=3,color=red


result0=hist_2d(mirs_image[*,*,0,0],(mirs_image[*,*,0,24]-mirs_image[*,*,0,0])/(mirs_image[*,*,1,24]-mirs_image[*,*,1,0])*100.,min1=0,max1=200,min2=85,max2=115)
result1=hist_2d(mirs_image[*,*,1,0],(mirs_image[*,*,1,24]-mirs_image[*,*,1,0])/(mirs_image[*,*,2,24]-mirs_image[*,*,2,0])*100.,min1=0,max1=200,min2=85,max2=115)
result2=hist_2d(mirs_image[*,*,2,0],(mirs_image[*,*,2,24]-mirs_image[*,*,2,0])/(mirs_image[*,*,3,24]-mirs_image[*,*,3,0])*100.,min1=0,max1=200,min2=85,max2=115)
result3=hist_2d(mirs_image[*,*,3,0],(mirs_image[*,*,3,24]-mirs_image[*,*,3,0])/(mirs_image[*,*,2,25]-mirs_image[*,*,2,1])*100.,min1=0,max1=200,min2=85,max2=115)
result4=hist_2d(mirs_image[*,*,2,1],(mirs_image[*,*,2,25]-mirs_image[*,*,2,1])/(mirs_image[*,*,3,25]-mirs_image[*,*,3,1])*100.,min1=0,max1=200,min2=85,max2=115)
result5=hist_2d(mirs_image[*,*,3,1],(mirs_image[*,*,3,25]-mirs_image[*,*,3,1])/(mirs_image[*,*,0,26]-mirs_image[*,*,0,2])*100.,min1=0,max1=200,min2=85,max2=115)

result=result0
result+=result1
result+=result2
result+=result3
result+=result4
result+=result5

atv,result,/block

;
; ATVs for checking 1st frame effect
;

atv,(mirs_image[*,*,0,24]-mirs_image[*,*,0,0])/(mirs_image[*,*,1,24]-mirs_image[*,*,1,0]),/block; flat, less than unit, 
atv,(mirs_image[*,*,1,25]-mirs_image[*,*,1,1])-(mirs_image[*,*,2,24]-mirs_image[*,*,2,0]),/block
atv,(mirs_image[*,*,0,25]-mirs_image[*,*,0,1])/(mirs_image[*,*,1,25]-mirs_image[*,*,1,1]),/block;
atv,mirs_image[*,*,0,0]-mirs_image[*,*,1,0],/block; flat, but non zero (positive)
atv,mirs_image[*,*,1,0]-mirs_image[*,*,2,0],/block; flat, closer to zero, but non zero
atv,mirs_image[*,*,2,0]-mirs_image[*,*,3,0],/block; flat, much closer to zero
atv,mirs_image[*,*,3,0]-mirs_image[*,*,2,1],/block
atv,mirs_image[*,*,0,24]-mirs_image[*,*,1,24],/block; residual pattern
atv,mirs_image[*,*,0,24]/mirs_image[*,*,1,24],/block; residual pattern
atv,(mirs_image[*,*,0,24]-mirs_image[*,*,3,23])/(mirs_image[*,*,0,24]-mirs_image[*,*,0,0]),/block

for j=0,254 do plot,(mirs_image[j,0:235,0,24]-mirs_image[j,0:235,0,0])/(mirs_image[j,0:235,1,24]-mirs_image[j,0:235,1,0]),psym=3,yrange=[0.9,1.1],xgridstyle=3,ygridstyle=3,xmargin=[5,5],ymargin=[5,5],xrange=[0,255]

END
