pro irc_spectrace,specimage3d,spec_xpos,spec_xpos_fit,fit_flag2,a0,a1,a2,weight

common CALC_SPECCOORD_PARAMS,specaper_dx,specaper_dy,imageaper_dx,imageaper_dy,x_offset,y_offset,x_zero_offset,y_zero_offset
common dir_structure,datadir,calibdir

set_dir

min_count_for_trace=10.

!y.range=0 & !x.range=0         ; plot reset

s=size(specimage3d) & xsize=s[1] & ysize=s[2]
if s[0] EQ 2 then n_source=1 else n_source=s[3]

xarray=indgen(xsize) & yarray=findgen(ysize)
spec_xpos=fltarr(ysize,n_source)
spec_xpos_fit=fltarr(ysize,n_source)
a0=fltarr(n_source) & a1=fltarr(n_source) & a2=fltarr(n_source)

xsize_min=7             ; central 7 pix will be used for final fitting
xarray_min=indgen(xsize_min)

;window,0,xsize=xsize*7,ysize=ysize*7,title='Peak Fit Result'
;estimate=[100,18,2,0,0]
width_guess=1.
width_thresh=10.                ;1.0

weight=fltarr(ysize,n_source)

for source_id=0,n_source-1 do begin
    print,'Now processing source id= ',source_id
;
; Rough center search...
;
; find the best pos at the center pos.
;    i=fix(ysize/2-y_offset)
;    space_cut=total(specimage3d[*,(i-3)>0:(i+3)<ysize,source_id],2)
    space_cut=total(specimage3d[*,*,source_id],2)
    xpos_guess=total(space_cut*xarray)/total(space_cut)
    int_guess=max(space_cut)
    estimate=[int_guess,xpos_guess,width_guess,0]
;   print,estimate
    if total(space_cut) EQ 0.0 or $ ; no data due to out of range when extracting
      n_elements(space_cut) LE 4 $ ; available data point number is less than fitting freedom.
      then begin
        spec_xpos[i,source_id]=0.
        weight[i,source_id]=1e-10 ; negligibly small
        fit_flag[i]=0
;       print,'skip fitting the cont. peak...'
    endif else begin
        
;       yfit=gaussfit(xarray,space_cut,coef,estimate=estimate,nterms=4)
        yfit=mpfitpeak(xarray,space_cut,coef,estimate=estimate,nterms=4,/positive,status=status,errmsg=errmsg)
        if status LE 0 then print,errmsg

        ; repeat the same fit, after limiting the
        ; fitting Y range, to find only peak
        ; position of the spectrum.

        coef2=fltarr(3)
        coef2[0]=coef[0]*2./3.
        coef2[1]=coef[1]
        coef2[2]=coef[2]
; sub constant background, and then use only 2/3 of top
        space_cut=((space_cut-coef[3]) > (coef[0]/3))-coef[0]/3.
;       yfit=gaussfit(xarray,space_cut,coef3,estimate=coef2,nterms=3)
        yfit=mpfitpeak(xarray,space_cut,coef3,estimate=coef2,nterms=3, $
                       /positive,status=status,errmsg=errmsg)
        if status LE 0 then print,errmsg

        shift_x=floor(coef3[1]-(xsize-1)/2) > 0 < (xsize-1) ; diff between measured peak pos and aperture center
        print,'initial guess: shift=',shift_x
    endelse

; do scan along Y
    fit_flag=intarr(ysize)
    weights=fltarr(n_elements(xarray_min)) & weights[*]=1.0
    width_guess=1.; in sigma
    amari=((xsize-xsize_min)/2.+shift_x)-floor((xsize-xsize_min)/2.+shift_x)
    print,'amari,shift_x=',amari,shift_x

    for i=0,ysize-1 do begin
       space_cut=specimage3d[((xsize-xsize_min)/2+shift_x) > 0 < (xsize-1): $
                              (xsize-(xsize-xsize_min)/2-1+shift_x) > 0 < (xsize-1), $
                              i,source_id]
        xpos_guess=xsize_min/2
        int_guess=max(space_cut)
        background_guess=min(space_cut)
        estimate=[int_guess,xpos_guess,width_guess,background_guess]
;       print,'Estimate is ',estimate
        if total(space_cut) EQ 0.0 or n_elements(space_cut) LE 4 then begin ; if out of range when extracting
            fit_flag[i]=0
            weight[i,source_id]=1e-10 ; negligibly small
            spec_xpos[i,source_id]=0.
            print,'skip due to no valid data'
        endif else begin       
;           yfit=gaussfit(xarray_min,space_cut,coef,estimate=estimate,nterms=4)
            yfit=mpfitpeak(xarray_min,space_cut,coef,estimate=estimate,nterms=4, $
                           /positive,status=status,errmsg=errmsg)
            if status LE 0 then print,errmsg

            peak_thresh=(3.*max(space_cut-yfit)) > 10.; set peak thresh; we need at least 10 counts for good fit.
                                ; repeat the same fit, after limiting the
                                ; fitting Y range, to find only peak
                                ; position of the spectrum.
            coef2=fltarr(3)
            coef2[0]=coef[0]*2./3. ; limit the fitting region
            coef2[1]=coef[1]
            coef2[2]=coef[2]
; sub constant background, and then use only 2/3 of top
            
            space_cut=((space_cut-coef[3]) > (coef[0]/3.))-coef[0]/3.
            if total(space_cut) EQ 0.0 or status LE 0 then begin ; if out of range when extracting
                fit_flag[i]=0
                weight[i,source_id]=1e-10 ; negligibly small
                spec_xpos[i,source_id]=0.
                print,'skip due to no data after peak cut'
            endif else begin     
;               yfit=gaussfit(xarray_min,space_cut,coef3,estimate=coef2,nterms=3,sigma=sigma)
                yfit=mpfitpeak(xarray_min,space_cut,coef3,estimate=coef2,nterms=3, $
                               /positive,perror=sigma,status=status,errmsg=errmsg, weights=weights)
                if status LE 0 then print,errmsg
                
                if(total(finite(sigma,/nan)) or total(finite(sigma,/infinity)) or $ ; Fit OK? (NAN check)
                   status LE 0 or $ ; status message from fitting function
                   coef3[0] LT peak_thresh or $ ; too short in amplitude
                   coef3[0] LT sqrt(sigma[0]) or $ ; too much error in amplitude?
                   coef3[2] GT width_thresh or $ ; too wide?
                   coef3[1] LE 0 or $ ; out of range?
                   coef3[1] GE xsize_min) $
                  then begin
                    print,'Gauss fit error'
                    fit_flag[i]=0
                    weight[i,source_id]=1e-10 ; negligibly small
                    spec_xpos[i,source_id]=0.
;                   print,coef3,peak_thresh,width_thresh,sqrt(sigma)
                endif else begin
                    print,'Gauss fit OK' ;: peak=',coef3[0],' peak_thresh=',peak_thresh,' width=',coef3[2]
;                   plot,xarray_min,space_cut,psym=10 & oplot,xarray_min,yfit,psym=0
                    weight[i,source_id]=coef3[0]
                    fit_flag[i]=1
                    spec_xpos[i,source_id]=(coef3[1]+(xsize-xsize_min)/2.+shift_x+amari) > 0 < xsize ; was amari-1
                    print,'Gauss fit OK: ',spec_xpos[i,source_id]
                endelse
            endelse
            
        endelse
    endfor                      ; of y scan
;
; Do fit the trace results.
;    
    fit_flag2=where(fit_flag EQ 1,count)
    if count GT 4 then begin ; if there are enough number of data available for fitting...
        weight_med=medsmooth(weight[*,source_id],3) ; median smooth weight function to remove comicray fits
        use_array=where(weight_med GT min_count_for_trace)
        distfitcoef=robust_poly_fit_w(yarray[use_array],spec_xpos[use_array,source_id], $
                                      weight_med[use_array],2,spec_xpos_fit_tmp,sig)
;       distfitcoef=polyfitw(yarray,spec_xpos[*,source_id],weight_med,2,spec_xpos_fit_tmp)

;       plot,weight[*,source_id]
;       plot,yarray,weight[*,source_id] & oplot,yarray,spec_xpos[*,source_id]
;       print,spec_xpos[*,source_id]
;       print,weight
;       spec_xpos_fit[fit_flag2,source_id]=spec_xpos_fit_tmp
        spec_xpos_fit[*,source_id]=distfitcoef[0]+distfitcoef[1]*yarray+distfitcoef[2]*yarray^2 ;spec_xpos_fit_tmp

    endif else begin
        distfitcoef=[-999,-999,-999]
;       spec_xpos_fit[*,source_id]=-999
    endelse

    a0[source_id]=distfitcoef[0]
    a1[source_id]=distfitcoef[1]
    a2[source_id]=distfitcoef[2]
        
endfor

a0=a0-max(xarray)/2.

;message,'Finish'

end
