pro make_response,wave_array,specimage_n_sff,specmask_n,source_table,source_id, $
                  whole_aperture=whole_aperture,space_shift=space_shift,nsum=nsum

  if ~ defined(whole_aperture) then whole_aperture=1
  
; preparation
  irc_wavecalib,specimage_n_sff,source_table,specimage_n_wc,wave_array
  
  if NG() || LG2() then d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) else $
     d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y))
  
  shift_wavelength,wave_array,d_wave_offset_pix[source_id],wave_array_shift
  
  irc_senscalib,specimage_n_wc,specimage_n_wc,mask_specimage_n,wave_array_shift,source_table,specimage_n_fc, $
                specimage_n_fc_short,sigmaimage_n_fc,sigmaimage_n_fc_short

  make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d, $
              /stdstar_mode,/no_mask,whole_aperture=whole_aperture, $
              space_shift=space_shift,nsum=nsum
  
  plot,wave_array_shift,specimage_wc_1d[*,source_id], $
       ytitle='Flux (Jy)',xtitle='Lambda (um)',xrange=w_cover,psym=10,color=white

; Calc response
  photon_noise_adu=fltarr(size(specimage_wc_1d,/dimensions))
  photon_noise_adu=sqrt(specimage_wc_1d[*,source_id]*!IRC_SPECRED_CHIPINFO.ADG)/!IRC_SPECRED_CHIPINFO.ADG
  noise_ADU=sqrt(photon_noise_adu^2.+source_table[source_id].spec_bgnoise_1d_ADU^2.)
  
  calc_specresponse,wave_array_shift,specimage_wc_1d[*,source_id],noise_ADU,response,d_response
  
; plot response
  plot,wave_array_shift,response,xrange=w_cover,color=white,psym=10
  err_plot,wave_array_shift,response+d_response,response-d_response,color=white
  
; write response
  write_response,source_table[source_id].image_x,source_table[source_id].image_y,wave_array_shift,response,d_response
  write_spec1d_wc,wave_array_shift,specimage_wc_1d,source_id
  
;plot,wave_array,specimage_wc_1d[*,source_id],color=red,psym=10
  
; do senscalib with newly created response
  set_response,response_lambda,response,d_response
  irc_senscalib,specimage_n_wc,specimage_n_wc,mask_specimage_n,wave_array_shift,source_table,specimage_n_fc, $
                specimage_n_fc_short,sigmaimage_n_fc,sigmaimage_n_fc_short
  
  make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d, $
              /stdstar_mode,/no_mask,whole_aperture=whole_aperture, $
              space_shift=space_shift,nsum=nsum
  
;; do smoothing
;n_smooth=5.
;specimage_fc_1d_smooth=poly_smooth(medsmooth(specimage_fc_1d[*,source_id],n_smooth),n_smooth)
;smooth_ratio=specimage_fc_1d_smooth/specimage_fc_1d[*,source_id]
;;print,smooth_ratio
;response_smooth=response/smooth_ratio
;d_response_smooth=d_response/sqrt(n_smooth)
;
;; plot smoothed resonse
;plot,wave_array_shift,response_smooth,xrange=w_cover,color=white,psym=10
;err_plot,wave_array_shift,response_smooth+d_response_smooth,response_smooth-d_response_smooth,color=red
  
;; write smoothed response
;write_response,source_table[source_id].image_x,source_table[source_id].image_y,wave_array_shift,response_smooth,d_response_smooth
;;write_spec1d_wc,wave_array_shift,specimage_wc_1d,source_id
  
; do senscalib with newly created response
  set_response,response_lambda,response,d_response
  irc_senscalib,specimage_n_wc,specimage_n_wc,mask_specimage_n,wave_array_shift,source_table,specimage_n_fc, $
                specimage_n_fc_short,sigmaimage_n_fc,sigmaimage_n_fc_short

  make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d, $
              /stdstar_mode,/no_mask,whole_aperture=whole_aperture, $
              space_shift=space_shift,nsum=nsum
  
; read cohen star info
  fileName = DIALOG_PICKFILE (PATH=!IRC_SPECRED_DIR.calibdir+'StdSpecData/', FILTER = '*.tem',title='COHEN STD Stars')
  read_cohen,cohen_lambda,cohen_flux,cohen_d_flux,count,filename
  
; plot spectra with Cohen template overlayed
  plot,wave_array_shift,specimage_fc_1d[*,source_id], $
       ytitle='Flux (Jy)',xtitle='Lambda (um)',xrange=w_cover,psym=10,color=white
  oplot,cohen_lambda,cohen_flux,psym=0,color=red ; overlay input for comparsion
  
end
