pro make_specflat,slit_mode=slit_mode,conserve_memory=conserve_memory,NG=NG,make_list_only=make_list_only

;
; How to make spec flat
; 1: collect images, and make initial list
; 2: run make_specflat, with make_list_only option
; 3: make a list listing frames of desired sky brightness range
; 4: run make_[mir/nir]_blink_list.sh list to review the listed images
; 6: remove frames with hide frames
; 7: edit list
; 8: run make_specflat with revised list

  common gui,logger

  flat_list='list.1750-1300.selected'
  flat_list='list.NG_NP'
  flat_list='list.2000'
  flat_list='list.new.1080.uniq'
  flat_list='list.nearEP'
  flat_list='BETA-ADS_high_beta.lst'

  FILTER_SPEC=dialog_menu(['N3_NP','N3_NG','S9W_SG1','S9W_SG2','L18W_LG2','OTHER'])
  init_specred,targetid,targetsubid,ext_source_table,refimage_list,specimage_list,filter_spec,/no_database_check

;  datadir2='~/hd1.cava/IRC/PV/SPEC/OBJ/processed/'
;  datadir2='~/hd1.cava/IRC/SPICY/1/all/'
;  flat_data_dir='/iris/irc01/irc/zzzzzz_LSLMC/NG/rawdata/' ; for LSLMC

  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        grow_width_set=6
        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              rawflatdatadir='/iris/irc01/irc/NP_ALL/rawdata/'
              rawflatdatadir='/iris/irc04/irc/IRC_QDL/PTM_DATA/NP_ALL/rawdata/'
              fac=2.0           ; was 3
              sigfac=3.0        ; was 2
              ceil=300 & bottom=200
           end
           1: begin
              rawflatdatadir='/iris/irc01/irc/NG_ALL/rawdata/'
              fac=2.0
              sigfac=3.0
              ceil=400 & bottom=50 ; was 200 for FOV
           end
        endcase
     end
     1: begin
        grow_width_set=3
        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
;             rawflatdatadir='/iris/irc01/irc/SG1_ALL/rawdata/'
              rawflatdatadir='/iris/irc01/irc/SG1_ALL_TEST/rawdata/NO_SORAMAME/'
              fac=3.0
              sigfac=3.0
              ceil=375 & bottom=100
           end
           1: begin
;             rawflatdatadir='/iris/irc01/irc/SG2_ALL/rawdata/'
              rawflatdatadir='/iris/irc01/irc/SG2_ALL_TEST/rawdata/NO_SORAMAME/'
              fac=3.0
              sigfac=3.0
              ceil=1750 & bottom=1300
;             ceil=1700 & bottom=1300
;             ceil=2000 & bottom=1900
           end
        endcase
     end
     2: begin
        grow_width_set=3
        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              rawflatdatadir='/iris/irc01/irc/LG2_ALL/rawdata/'
              fac=3.0
              sigfac=3.0
           end
           1: begin
              rawflatdatadir='/iris/irc01/irc/LG2_ALL/rawdata/'
              fac=3.0
              sigfac=3.0
              ceil=1080 & bottom=950
           end
        endcase 
     end
  endcase
  
; for slit flat, set this.
  if keyword_set(slit_mode) then fac=100.

  irc_list_read,list,num,list_in=flat_list,dir=rawflatdatadir

  irc_list_fits_read,flat_list,image_nir,image_mirs,image_mirl,n_nir,n_mir,header_nir,header_mirs,header_mirl, $
                     dir=rawflatdatadir
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        image=image_nir
        header=header_nir
     end
     1: begin
        image_mirl=0B
        image=image_mirs
        image_mirs=0B
        header=header_mirs
     end
     2: begin
        image_mirs=0B
        image=image_mirl
        image_mirl=0B
        header=header_mirl
     end
  endcase
  
; set dark files
  set_superdark,dark,darkheader
  
  if NIR() then imrot_NIR,refimage,image,imageflat,specflat,dark,dark2
  
; reform
  reform_irc_cube,image,image_reform,image_reform_short

  if keyword_set(conserve_memory) then image=0B ; conserve memory
; dark sub

  if keyword_set(make_list_only) then image_reform_short=0B
  
  irc_darksub,image_reform,dark,refdark,image_reform_ds ;,/scale; no scale because no refdark present.
  if keyword_set(conserve_memory) then image_reform=0B ; conserve memory

; only for NG at NP
  if keyword_set(NG) then begin
     irc_darkfeature_sub,image_reform_ds,image_reform_ds_dfs
     image_reform_ds=image_reform_ds_dfs
     if keyword_set(conserve_memory) then image_reform_ds_dfs=0B ; conserve memory
  endif

; sky norm
  irc_skyadjust_cube,image_reform_ds,image_reform_ds_skynorm, $
                     /mode_norm,sigma=sigma,ceil=ceil,bottom=bottom,use_array=use_array,make_list_only=make_list_only
  if keyword_set(conserve_memory) then image_reform_ds=0B ; conserve memory

  if keyword_set(make_list_only) then message,'Finish! (make list only)'
  
; make temporary flat
  irc_imcombine_n,image_reform_ds_skynorm,image_reform_short,tmpspecflat,/no_shift,clip_sig=sigfac
  clean_flat_image,tmpspecflat,tmpspecflat_clean,/interp

; do flat calib
  irc_2dflatcalib,image_reform_ds_skynorm,tmpspecflat_clean,image_reform_ff
  
  s=size(image_reform_ds_skynorm) & n_frame=s[3]
  for i=0,n_frame-1 do begin
     tmp=image_reform_ds_skynorm[*,*,i] & tmp_ff=image_reform_ff[*,*,i]
     make_hotpixel_mask,tmp_ff,tmp_ff_mask
     badarea=where(tmp_ff LT 1.-fac*sigma[i] OR tmp_ff GT 1.+fac*sigma[i] OR finite(tmp_ff_mask,/NAN),count)
     if count GT 0 then tmp[badarea]=!values.F_NAN
     if LG2() then begin        ; remove cross structure aroud the hot pixel.
        mask_grow,tmp,tmp_grow,grow_width=-1
        tmp=tmp_grow
     endif

     image_reform_ds_skynorm[*,*,i]=tmp
  endfor
  
  if keyword_set(conserve_memory) then image_reform_ff=0 ; conserve memory
  
  irc_imcombine_n,image_reform_ds_skynorm,image_reform_short,avgimage, $
                  /no_shift,clip_sig=sigfac,rmsimage=rmsimage
  
;sxdelpar,header,'naxis3'
  header_single=header[*,0]
  sxdelpar,header_single,'naxis3'

  message,'Finish'
  
  clean_flat_image,avgimage,avgimage_clean,/interp

  atv,rmsimage[*,*,1],/block
  atv,avgimage[*,*,1],/block
  write_fits,avgimage[*,*,1],header_single,dir=!IRC_SPECRED_DIR.calibdir+'FLAT/NEW'
  
  if NIR() then begin
     avgimage=rotate(avgimage[*,*,1],3) ; de-rotate_NIR image
     rmsimage=rotate(rmsimage[*,*,1],3) ; de-rotate_NIR image
     write_fits,avgimage,header_single,dir=!IRC_SPECRED_DIR.calibdir+'FLAT'
  endif
  
  use_array2=where(use_array EQ 1, count)
  print,list[fix(use_array2/3)] ; 3 means 3 sub_frames per MIR, 1 for NIR
  write_list,list[fix(use_array2/3)]

end
