PRO memoryeffect

ncolor_plot=6
white  = GetColor('white',  !D.Table_Size-(ncolor_plot-5))
yellow = GetColor('yellow', !D.Table_Size-(ncolor_plot-4))
red    = GetColor('red',    !D.Table_Size-(ncolor_plot-3))
green  = GetColor('green',  !D.Table_Size-(ncolor_plot-2))

;imagelist='/home/ohyama/FECs/FEC6/050106/shorterdark.lst'
;imagelist='/home/ohyama/FECs/FEC6/050106/longdark.lst'

;imagelist='/home/ohyama/FECs/FEC6/050106/contall3.lst'
;cd,       '/home/ohyama/FECs/FEC6/050106/'

imagelist='/home/ohyama/FECs/FEC7/050214_1640/memory_dark.lst'
imagelist2='/home/ohyama/FECs/FEC7/050214_1640/memory_cal81.lst'
darklist='/home/ohyama/FECs/FEC7/050214_1640/memory_dark0.lst'
cd,       '/home/ohyama/FECs/FEC7/050214_1640/'

; dark read
irc_list_fits_read,darklist,NIR_dark, MIRS_dark,MIRL_dark,n_nir,n_mir
; frame read
irc_list_fits_read,imagelist,NIR_image, MIRS_image,MIRL_image,n_nir,n_mir
; CAL frame read
irc_list_fits_read,imagelist2,NIR_image2, MIRS_image2,MIRL_image2,n_nir,n_mir

NIR_image=NIR_image-NIR_dark
MIRS_image=MIRS_image-MIRS_dark
MIRL_image=MIRL_image-MIRL_dark

NIR_image2=NIR_image2-NIR_dark
MIRS_image2=MIRS_image2-MIRS_dark
MIRL_image2=MIRL_image2-MIRL_dark

ncol_nir = 412L                 ; X
nrow_nir = 512L                 ; Y
ncol_mir = 256L                 ; X
nrow_mir = 256L                 ; Y

; for NIR

n=long(n_nir)                         ;n_elements(mirs_image[0,0,0,*])
mean_nir_xy=fltarr(ncol_nir,nrow_nir,n*2)
time_nir=fltarr(n*2*ncol_nir*nrow_nir)

k=0L
for x=0,ncol_nir-1 do begin
    for y=0,nrow_nir-1 do begin
        for j=0,n*2-1 do begin
            if nir_image2[x,y,j mod 2,11] LT 10000 AND nir_image2[x,y,j mod 2,11] GT 10$
            then mean_nir_xy[x,y,j]=nir_image[x,y,j mod 2,fix(j/2)]/nir_image2[x,y,j mod 2,11]$
            else mean_nir_xy[x,y,j]=100.
            time_nir[k]=j
            k=k+1
        endfor
    endfor
endfor

mean_nir2=fltarr(n*2)
for j=0,n*2-1 do if j mod 2 NE 0 then mean_nir2[j]=meanclip_func(mean_nir_xy[*,*,j],3) else mean_nir2[j]=-1.
plot,mean_nir2,psym=4,yrange=[-0.005,0.005]

; for MIR

n=long(n_mir)                         ;n_elements(mirs_image[0,0,0,*])
mean_mirs_xy=fltarr(ncol_mir,nrow_mir,n*4)
mean_mirl_xy=fltarr(ncol_mir,nrow_mir,n*4)
time_MIR=fltarr(n*4*ncol_mir*nrow_mir)

k=0L
for x=0,ncol_mir-1 do begin
    for y=0,nrow_mir-1 do begin
        for j=0,n*4-1 do begin
            mean_mirs_xy[x,y,j]=mirs_image[x,y,j mod 4,fix(j/4)]/mirs_image2[x,y,j mod 4,11]
            mean_mirl_xy[x,y,j]=mirl_image[x,y,j mod 4,fix(j/4)]/mirl_image2[x,y,j mod 4,11]
            time_mir[k]=j
            k=k+1
        endfor
    endfor
endfor

mean_mirs2=fltarr(n*4)
for j=0,n*4-1 do if j mod 4 NE 0 then mean_mirs2[j]=meanclip_func(mean_mirs_xy[*,*,j],3) else mean_mirs2[j]=-1.
;for j=0,n*4-1 do mean_mirs2[j]=mean(mean_mirs_xy[*,100:200,j])
;for j=0,n*4-1 do mean_mirs2[j]=mean(mean_mirs_xy[100:200,100:200,j])
;for j=0,n*4-1 do mean_mirs2[j]=mean(mean_mirs_xy[0:100,0:100,j])
;for j=0,n*4-1 do mean_mirs2[j]=mean(mean_mirs_xy[100:200,*,j])
plot,mean_mirs2,psym=4,yrange=[1e-5,0.005],/ylog

mean_mirl2=fltarr(n*4)
for j=0,n*4-1 do if j mod 4 NE 0 then mean_mirl2[j]=meanclip_func(mean_mirl_xy[*,*,j],3) else mean_mirl2[j]=-1.
;for j=0,n*4-1 do mean_mirl2[j]=mean(mean_mirl_xy[0:100,*,j])
;for j=0,n*4-1 do mean_mirl2[j]=mean(mean_mirl_xy[*,*,j])
;for j=0,n*4-1 do mean_mirl2[j]=mean(mean_mirl_xy[*,*,j])
plot,mean_mirl2,psym=4,yrange=[1e-5,0.005],/ylog

message,'Finish'

mydevice = !D.NAME
SET_PLOT, 'PS'
;DEVICE, FILENAME='memory_NIR.ps', /LANDSCAPE,/color
;DEVICE, FILENAME='adgain_MIRS.ps', /LANDSCAPE,/color
DEVICE, FILENAME='adgain_MIRL.ps', /LANDSCAPE,/color

DEVICE, /CLOSE               ; Return plotting to the original device:
SET_PLOT, mydevice

END
