pro specdist_fit,source_table,use_array,a0,a1,a2,coef_a0,coef_a1,coef_a2
COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

; fit individual distortion data to get coefficients.

use_array2=where(use_array EQ 1,count)
if count EQ 0 then message,'There are no good data to fit...Stop'

; 3D plotting of dist params/fitting
;plot_3dbox,source_table.image_x,source_table.image_y,a0,zrange=[-5,5],psym=5
;plot_3dbox,source_table.image_x,source_table.image_y,a1,zrange=[1e-1,-1e-1],psym=5
;plot_3dbox,source_table.image_x,source_table.image_y,a2,zrange=[1e-3,-1e-3],psym=5,az=45,ax=45

; Do 2D fit.
; This is an outlier-resistant fit to Z = a + bX + cY
coef_a0_linear= $
  robust_planefit(source_table[use_array2].image_x,source_table[use_array2].image_y,a0[use_array2],a0fit_linear,a0sig_linear)
coef_a1_linear= $
  robust_planefit(source_table[use_array2].image_x,source_table[use_array2].image_y,a1[use_array2],a1fit_linear,a1sig_linear)
coef_a2_linear= $
  robust_planefit(source_table[use_array2].image_x,source_table[use_array2].image_y,a2[use_array2],a2fit_linear,a2sig_linear)

; This is an outlier-resistant fit to Z = a + bX + cX^2 + eY +fY^2 + dX*Y.
; This should work better.
coef_a0_quart= $
  rob_quarticfit(source_table[use_array2].image_x,source_table[use_array2].image_y,a0[use_array2],a0fit_quart,a0sig_quart)
coef_a1_quart= $
  rob_quarticfit(source_table[use_array2].image_x,source_table[use_array2].image_y,a1[use_array2],a1fit_quart,a1sig_quart)
coef_a2_quart= $
  rob_quarticfit(source_table[use_array2].image_x,source_table[use_array2].image_y,a2[use_array2],a2fit_quart,a2sig_quart)

s=size(a0sig_quart) & if s[0] EQ 0 then a0sig_quart=999; in case of fit failure, set sigma to be 999.
s=size(a1sig_quart) & if s[0] EQ 0 then a1sig_quart=999; in case of fit failure, set sigma to be 999.
s=size(a2sig_quart) & if s[0] EQ 0 then a2sig_quart=999; in case of fit failure, set sigma to be 999.

;
; check if sigma decreased
;
print,'mean (obs, linear, res), sigma(res):'
print,mean(a0[use_array2]),mean(a0fit_linear),mean(a0[use_array2]-a0fit_linear),robust_sigma_mod(a0[use_array2]-a0fit_linear)
print,mean(a1[use_array2]),mean(a1fit_linear),mean(a1[use_array2]-a1fit_linear),robust_sigma_mod(a1[use_array2]-a1fit_linear)
print,mean(a2[use_array2]),mean(a2fit_linear),mean(a2[use_array2]-a2fit_linear),robust_sigma_mod(a2[use_array2]-a2fit_linear)

if a0sig_linear LT a0sig_quart then begin; compacare and find better fit
    coef_a0=[coef_a0_linear[0],coef_a0_linear[1],0.,0.,coef_a0_linear[2],0.]
    coef_a1=[coef_a1_linear[0],coef_a1_linear[1],0.,0.,coef_a1_linear[2],0.]
    coef_a2=[coef_a2_linear[0],coef_a2_linear[1],0.,0.,coef_a2_linear[2],0.]
    a0fit=a0fit_linear
    a1fit=a1fit_linear
    a2fit=a2fit_linear
endif else begin
    coef_a0=coef_a0_quart
    coef_a1=coef_a1_quart
    coef_a2=coef_a2_quart
    a0fit=a0fit_quart
    a1fit=a1fit_quart
    a2fit=a2fit_quart
endelse

;
; do plot to check fitting
;
;plot,source_table[use_array2].image_x,a0[use_array2],psym=4,yrange=[-5,5],color=white
;oplot,source_table[use_array2].image_x,a0fit,psym=7,color=red
;plot,source_table[use_array2].image_y,a0[use_array2],psym=4,yrange=[-5,5],color=white
;oplot,source_table[use_array2].image_y,a0fit,psym=7,color=red

;plot,source_table[use_array2].image_y,a1[use_array2],psym=4,yrange=[-0.5,0.5]
;oplot,source_table[use_array2].image_y,a1fit,psym=7,color=red

;plot,source_table[use_array2].image_x+source_table[use_array2].image_y,a2[use_array2],psym=4,yrange=[-0.05,0.05],color=white
;oplot,source_table[use_array2].image_x+source_table[use_array2].image_y,a2fit,psym=7,color=red

;message,'Finish'

end
