pro tweak_coo
  
; input [x1,y1],[x2,y2],[x3,y3]
; output [x1_min,y1_min],[x2_min,y2_min],[x3_min,y3_min]

; file read

  filename=DIALOG_PICKFILE(PATH='~',filter='*.coo.1')
  IF(STRLEN(filename) EQ 0) THEN stop
  
  readcol,filename,x1,y1,z1,format='F,F,F'
  
  filename=DIALOG_PICKFILE(PATH='~',filter='*.coo.1')
  IF(STRLEN(filename) EQ 0) THEN stop
  
  readcol,filename,x2,y2,z2,format='F,F,F'
  
  filename=DIALOG_PICKFILE(PATH='~',filter='*.coo.1')
  IF(STRLEN(filename) EQ 0) THEN stop
  
  readcol,filename,x3,y3,z3,format='F,F,F'
  
  max_separation=4              ; pix (consider the dithering distance)

  n1=n_elements(x1)
  n2=n_elements(x2)
  n3=n_elements(x3)

; distance check

; 1 vs 2
  d_min12=fltarr(n1)
  for i=0,n1-1 do begin
     d=fltarr(n2)
     for j=0,n2-1 do begin
        d[j]=sqrt((x1[i]-x2[j])^2.+(y1[i]-y2[j])^2.)
     endfor
     d_min12[i]=min(d)
  endfor
  
  d_min21=fltarr(n2)
  for i=0,n2-1 do begin
     d=fltarr(n1)
     for j=0,n1-1 do begin
        d[j]=sqrt((x1[j]-x2[i])^2.+(y1[j]-y2[i])^2.)
     endfor
     d_min21[i]=min(d)
  endfor

; 1 vs 3
  d_min13=fltarr(n1)
  for i=0,n1-1 do begin
     d=fltarr(n3)
     for j=0,n3-1 do begin
        d[j]=sqrt((x1[i]-x3[j])^2.+(y1[i]-y3[j])^2.)
     endfor
     d_min13[i]=min(d)
  endfor

  d_min31=fltarr(n3)
  for i=0,n3-1 do begin
     d=fltarr(n1)
     for j=0,n1-1 do begin
        d[j]=sqrt((x1[j]-x3[i])^2.+(y1[j]-y3[i])^2.)
     endfor
     d_min31[i]=min(d)
  endfor

; 2 vs 3
  d_min23=fltarr(n2)
  for i=0,n2-1 do begin
     d=fltarr(n3)
     for j=0,n3-1 do begin
        d[j]=sqrt((x2[i]-x3[j])^2.+(y2[i]-y3[j])^2.)
     endfor
     d_min23[i]=min(d)
  endfor
  
  d_min32=fltarr(n3)
  for i=0,n3-1 do begin
     d=fltarr(n2)
     for j=0,n2-1 do begin
        d[j]=sqrt((x2[j]-x3[i])^2.+(y2[j]-y3[i])^2.)
     endfor
     d_min32[i]=min(d)
  endfor

; find neighbors

  use_array1=where(d_min12 LT max_separation AND d_min13 LT max_separation,count1)
  x1_min=x1[use_array1]
  y1_min=y1[use_array1]

  use_array2=where(d_min21 LT max_separation AND d_min23 LT max_separation,count2)
  x2_min=x2[use_array2]
  y2_min=y2[use_array2]

  use_array3=where(d_min32 LT max_separation AND d_min31 LT max_separation,count3)
  x3_min=x3[use_array3]
  y3_min=y3[use_array3]

  message,'Finish'

  plot,x1,y1,psym=5
  oplot,x2,y2,psym=2
  oplot,x3,y3,psym=7

  plot,x1_min,y1_min,psym=5
  oplot,x2_min,y2_min,psym=2
  oplot,x3_min,y3_min,psym=7
 
end
