pro zerolightmap

filename='~/GRIDSPEC/LG2_L20W_zerolight_map.txt'
filename='~/GRIDSPEC/SG1_S9W_zerolight_map.txt'
filename='~/GRIDSPEC/SG2_S9W_zerolight_map.txt'

max_data=50

x_zero=fltarr(max_data)
y_zero=fltarr(max_data)
x_im=fltarr(max_data)
y_im=fltarr(max_data)

buf=''

GET_LUN,U
openr,U,filename

i=0
repeat begin
    READF,U, buf
    if buf EQ '' then break
    s=strsplit(buf,/extract)
;   READF, U,x_zero_tmp,y_zero_tmp,x_im_tmp,y_im_tmp
    x_zero[i]=float(s[0])
    y_zero[i]=float(s[1])
    x_im[i]=float(s[2])
    y_im[i]=float(s[3])
    i=i+1
endrep until EOF(U)

x_zero=x_zero[0:i-1]
y_zero=y_zero[0:i-1]
x_im=x_im[0:i-1]
y_im=y_im[0:i-1]

close,U
FREE_LUN,U

d_x=x_zero-x_im
d_y=y_zero-y_im

PARTVELVEC, [d_x-mean(d_x),1], [d_y-mean(d_y),1], [x_im,10], [y_im,10], xrange=[0,255],yrange=[0,255]
print,'mean/stddev shift vector= ',mean(d_x),mean(d_y),stddev(d_x),stddev(d_y)

message,'Finish'

end
