pro calc_np_distortion_cor,specimage_wc_1d,source_table,peak_mean_pos,peak_fit_pos, $
                           coef=coef,use_array=use_array,mes_max=mes_max,mes_min=mes_min,error_array=error_array, $
                           spec1d_wc=spec1d_wc,flux=flux

  n_source=n_elements(source_table)
  use_array=intarr(n_source) & peak_fit_pos=fltarr(n_source) & flux=fltarr(n_source) & error_array=fltarr(n_source)

  flux_thresh=!IRC_SPECRED_SPECDETECTPARAM.flux_thresh_for_distortion_measure
  if source_table[0].flux EQ 0 then flux_thresh=0.

  if ~ defined(mes_max) then begin
     mes_max=20 & mes_min=2
  end
  xarray=findgen(15)

  ysize=n_elements(specimage_wc_1d[*,0])

  im1=fltarr(5,ysize)
  for i=0,4 do im1[i,*]=spec1d_wc

  k=0
  for source_id=0,n_source-1 do begin
     peak_pos=where(specimage_wc_1d[*,source_id] EQ max(specimage_wc_1d[*,source_id]),count)
     peak_pos_ok= $
        peak_pos[0] LT mes_max && peak_pos[0] GT mes_min && count EQ 1 $
        && source_table[source_id].image_y LT 412+!IRC_SPECRED_SPECEXTRACTPARAM.y_offset-30 $
        && source_table[source_id].image_y GT (!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1)/2-!IRC_SPECRED_SPECEXTRACTPARAM.y_offset
     if peak_pos_ok then begin
        im2=fltarr(5,ysize)
        for i=0,4 do im2[i,*]=specimage_wc_1d[*,source_id]
        
        cor=correl_images_mod(im1,im2) 
        cor_1d=cor[7,*]

        result=mpfitpeak_nan(xarray,cor_1d,A,nterms=5,sigma=sigma,/positive, $
                             dof=dof,perror=perror,bestnorm=bestnorm)
        if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,0,0,0]
        if error[1] LT 0.2 && error[1] GT 1e-5 && A[0] GT 0.8 && $
           source_table[source_id].flux GE flux_thresh && source_table[source_id].bad_sourcepos_flag EQ 0B then begin

           if !IRC_SPECRED_MISC.DEBUG then begin
              plot,xarray,cor_1d,color=!IRC_SPECRED_COLOR.black,yr=[0,1.]
              oplot,xarray,result,color=!IRC_SPECRED_COLOR.red
              if defined(a) then oplot,[a[1],a[1]],[0.,1.],color=!IRC_SPECRED_COLOR.blue
              wait,0.5
           endif
 
;           print,'Information (calc_np_distortion_cor): correlation peak flux is at ' $
;                +strim(A[1])+' for source id '+strim(source_id)

           peak_fit_pos[source_id]=-1.*(A[1]-7.) ; for consistency with calc_np_distortion
           error_array[source_id]=error[1]
           use_array[k]=source_id
           flux[source_id]=source_table[source_id].flux
           k+=1
        endif
     endif
  endfor                        ; of source_id loop
  
  if k GT 0 then begin
     use_array=use_array[0:k-1]
;    error_array=error_array[0:k-1]
  endif else begin
     print,'Warning (calc_np_distortion_cor): No data are available for measurement... Returning 0!'
     peak_fit_pos=0. & peak_mean_pos=0.
     return
  endelse
  
  peak_fit_pos=peak_fit_pos[use_array]
  flux=flux[use_array] 
  error_array=error_array[use_array]

  flux_sort_key=reverse(sort(flux))
  peak_fit_pos=peak_fit_pos[flux_sort_key]
  flux=flux[flux_sort_key]

  if k GT 50 then begin         ; was 10
     print,'Information (calc_np_distortion_cor): using only 50 brightest sources for measuring the NP offset.'
     peak_fit_pos=peak_fit_pos[0:49]
     flux=flux[0:49]
     error_array=error_array[0:49]
  endif

; average peak_fit_pos array to find peak_mean_pos
; robomean,peak_fit_pos,3.0,0.5,peak_mean_pos,avgdev,stddev_value,var,skew,kurt,nfinal,new
  meanclip_mod,peak_fit_pos,peak_mean_pos,sigma,clipsig=3.0,weight=flux
  peak_fit_sigma=robust_sigma_mod(peak_fit_pos)
  if peak_fit_sigma GT 1. then $
     print,'Warning (calc_np_disttortion): error of specbox Y shift seems too large! '+strim(peak_fit_sigma)+ ' (pix)'
  
  if n_elements(use_array) GT 7 then $
     coef=rob_quarticfit(source_table[use_array].spec_x,source_table[use_array].spec_y,peak_fit_pos-peak_mean_pos,fit,sig)

; print,peak_fit_pos,flux,error_array,peak_mean_pos
; plot,flux/error_array^2.,peak_fit_pos,color=!irc_specred_color.black,psym=4
  
; This is an outlier-resistant fit to Z = a + bX + cX^2 + dY +eY^2 + fX*Y.
  
;  plot,source_table[use_array].image_y,peak_fit_pos-peak_mean_pos-fit,psym=4,color=!IRC_SPECRED_COLOR.white ;,yrange=[-0.5,0.5]
;  plot,source_table[use_array].image_x,peak_fit_pos-peak_mean_pos-fit,psym=4,color=!IRC_SPECRED_COLOR.white ;,yrange=[-0.5,0.5]
;  print,sig

 
end
