pro calc_shift_specbox_x,specimage3d,mask_specimage_n,mask_specimage_n_remove_all,source_table, $
                         mean_d_offset,sigma_mean_d_offset, $
                         SKYSUB=SKYSUB

  common gui,logger

  if ~ defined(mask_specimage_n) then begin
     mask_specimage_n=specimage3d
     mask_specimage_n[*,*,*]=1.0
  endif

  if !IRC_SPECRED_OBSPARAM.preflight_mode then begin
     print,'Information (calc_shift_specbox_x): This is preflight data processing mode.'
     mean_d_offset=0. & sigma_mean_d_offset=0.
     return
  endif

  s=size(specimage3d) & xsize=s[1]

  if NIR() then max_possible_shift=7 else max_possible_shift=4 ; max_possible_shift=(1/2 of measure total width)
  mes_min=((xsize-1)/2-max_possible_shift) > 0 & mes_max=xsize-mes_min

  n_source=n_elements(source_table)
  space_profile=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,n_source)
  offset=fltarr(n_source)
  weight=fltarr(n_source)
  peak=fltarr(n_source)
  use_array=intarr(n_source)
  k=0

; Set image flux threshold for positional shift calculation.
  if source_table[0].flux EQ 0 then flux_thresh=0. else begin ; finite for flux?
     flux_thresh=!IRC_SPECRED_SPECDETECTPARAM.flux_thresh
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        flux_thresh/=!IRC_SPECRED_CHIPINFO.short_long_exposure_rat

     flux_max=100000.
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        flux_max/=!IRC_SPECRED_CHIPINFO.short_long_exposure_rat
  endelse

  FWHM_MAX=!IRC_SPECRED_SPECDETECTPARAM.max_fwhm
  FWHM_MIN=!IRC_SPECRED_SPECDETECTPARAM.min_fwhm

  if source_table[0].image_FWHM EQ 0 then fwhm_min=0.

  spec_x_FWHM_default=5.

; xarray=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx)

  FOR source_id=0,n_source-1 DO begin
     
     if source_table[source_id].bad_sourcepos_flag EQ 1B then begin
;       print,'--- calc_shift_specbox_x: ',source_id,' skipped due to bad sourcepos flag.'
;       source_table[source_id].spec_mask_dx=!IRC_SPECRED_SPECEXTRACTPARAM.spec_mask_dx_min
        source_table[source_id].spec_x_FWHM=spec_x_FWHM_default
        source_table[source_id].spec_x_pos=(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
        continue
     endif
     
     if keyword_set(skysub) then begin
;       irc_calcsky_mmm,specimage3d[*,*,source_id],skymod,skysigma
        skymod=median(specimage3d[*,*,source_id])
        specimage2d=specimage3d[*,*,source_id]-skymod
     endif else specimage2d=specimage3d[*,*,source_id]
     
; make space_profile

     mask_specimage2d=mask_specimage_n[*,*,source_id]
     make_space_profile,specimage2d,mask_specimage2d,xarray,space_profile_source_id
     space_profile[*,source_id]=space_profile_source_id

;     get_valid_y_range,cut_in,cut_out
                                ; skusub
;;     irc_skysub_spec,specimage2d,mask_specimage_n_remove_all[*,*,source_id],specimage2d_bg,sigma
;     specimage2d_bg=specimage2d
;                                ; CR filter
;     specimage2d_sigmafilter=sigma_filter(specimage2d_bg,radius=1,/all,/iterate)
;     for x=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1 do begin
;        mask=mask_specimage_n[*,*,source_id]
;        masked_region=where(mask EQ 0, count)
;        if count GT 0 then mask[masked_region]=!values.f_nan
;;       irc_calcsky_mmm,specimage2d_sigmafilter*mask,skymod,sigma
;        sigma=robust_sigma_mod(specimage2d_sigmafilter)
;        skymod=median(specimage2d_sigmafilter)
;        clipped_region=where(specimage2d_sigmafilter LT 1.*sigma+skymod,count)
;        if count GT 0 then mask[clipped_region]=!values.f_nan
;        
;        array=specimage2d_sigmafilter[x,cut_in:cut_out]*mask[x,cut_in:cut_out]
;        calc_region=where(finite(array),count)
;        if count GT 5 then begin
;;          robomean,array[calc_region],3,0.5,mean_tmp,stddev,sigma,var,skew,kurt,nfinal,new,error=error $
;;          meanclip_mod,array[calc_region],mean_tmp,sigma,clipsig=3 $
;           mean_tmp=total(array[calc_region])
;        endif else mean_tmp=0.
;        space_profile[x,source_id]=mean_tmp
;     endfor

;     space_profile[*,source_id]=total(specimage3d[*,*,source_id]*mask_specimage_n[*,*,source_id],2)
;     plot,xarray,space_profile[*,source_id]print,mean,color=0
;     wait,0.5
     
     non_nan_region=where(finite(space_profile),count) ;where(space_profile NE 0., count)
     if count GT 10 then begin
        if ~ MIRL() then $
           result=mpfitpeak_nan( $
                  xarray[mes_min:mes_max],space_profile[mes_min:mes_max,source_id],A,nterms=6,sigma=sigma,/positive, $
                  dof=dof,perror=perror,bestnorm=bestnorm,errmsg=errmsg) $
        else $
           result=mpfitpeak_nan( $
                  xarray[mes_min:mes_max],space_profile[mes_min:mes_max,source_id],A,nterms=6,sigma=sigma,/positive, $
                  dof=dof,perror=perror,bestnorm=bestnorm,/lorentzian,errmsg=errmsg)
        
        if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,0.,0.,0.,0.]
        
        FWHM=source_table[source_id].image_FWHM ;A[2]*2.355
        peak[source_id]=A[0]
        
;       print,'errmsg',errmsg,FWHM,FWHM_MAX,FWHM_MIN,source_table[source_id].flux,flux_thresh

        if ~ defined(A) then A=fltarr(6) ; when undefined, then set dummy to A [0,0,0,0,0,0]
        
        if errmsg EQ '' && $
           FWHM LT FWHM_MAX && FWHM GE FWHM_MIN && $
           source_table[source_id].flux GE flux_thresh && $
           source_table[source_id].flux LE flux_max && $
           A[1] GT (!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2-10 $
           && A[1] LT (!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2+10 && finite(A[1]) $
           && finite(error[1]) && error[1] NE 0. then begin
           
;          if !IRC_SPECRED_MISC.DEBUG then begin
;              plot,xarray,space_profile[*,source_id],color=!IRC_SPECRED_COLOR.white,psym=10,/ynozero
;              oplot,xarray[mes_min:mes_max],result,color=!IRC_SPECRED_COLOR.red
;              wait,1.0
;           endif
           
           use_array[k]=source_id
           k+=1
; set offset
           offset[source_id]=A[1]
;          weight[source_id]=1./(error[1])^2. ; source_table[source_id].flux
;          weight[source_id]=peak[source_id]^2.; was 1./peak[source_id]^2., and was a bug
           weight[source_id]=source_table[source_id].flux

;           if finite(weight[source_id],/NAN) || finite(offset[source_id],/NAN) then begin
;              offset[source_id]=0.
;              weight[source_id]=0.
;           endif

;          source_table[source_id].spec_x_pos=(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
           
; set FWHM (auto)
           source_table[source_id].spec_x_FWHM=source_table[source_id].image_FWHM
        endif else begin        ; in case of fitting error
           if !IRC_SPECRED_PROCESSOPTION.interactive_skyset_mode then begin
; set mask_dx (manual)
              plot,xarray,space_profile[*,source_id],color=!IRC_SPECRED_COLOR.white,psym=10,/ynozero
              print,'Click' & cursor,x1,y1 & wait,0.2
              print,'Click again' & cursor,x2,y2 & wait,0.2
;             source_table[source_id].spec_mask_dx=fix(x2-x1+1)
;             source_table[source_id].spec_x_pos=(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
              
              oplot,[x1,x1],[0,max(space_profile[*,source_id])],color=!IRC_SPECRED_COLOR.green,linestyle=2
              oplot,[x2,x2],[0,max(space_profile[*,source_id])],color=!IRC_SPECRED_COLOR.green,linestyle=2
           endif else begin
; set mask_dx (default)
;             print,'--- calc_shift_specbox_x: ',source_id,' fit was bad.'
;             source_table[source_id].spec_mask_dx=!IRC_SPECRED_SPECEXTRACTPARAM.spec_mask_dx_min
              source_table[source_id].spec_x_FWHM=spec_x_FWHM_default
;             source_table[source_id].spec_x_pos=(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
           endelse
        endelse
        
     endif
     
  endfor                        ; of source_id loop

  if k EQ 0 then begin          ; when there are some good data to measure peak pos.
     print,'Warning (calc_shift_specbox_x): No data are available for measurement... Returning 0!'
     mean_d_offset=0.
     sigma_mean_d_offset=0.
     return
  endif
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: use_num=10
     else: use_num=7
  endcase
  
  use_array=use_array[0:k-1]

; if NP() then message,'Finish'

;  if n_elements(use_array) GE 5 then begin
  if n_elements(use_array) GT use_num then begin ; when too many data are available...
     offset2=offset[use_array] & weight2=weight[use_array]
     source_table_tmp=source_table[use_array]
;    peak_tmp=peak[use_array]
     peak_tmp=source_table[use_array].flux
;    sort_key=reverse(sort(source_table_tmp.flux))
     sort_key=reverse(sort(peak_tmp))
     offset3=offset2(sort_key) & weight3=weight2(sort_key)
     offset=offset3[0:use_num-1] & weight=weight3[0:use_num-1]
     use_array=findgen(use_num)
     meanclip_mod,offset,mean_offset,sigma_mean_d_offset,weight=weight,clipsig=3.
;    robomean,offset[use_array],3,0.5,mean_offset,stddev,sigma_mean_d_offset,var,skew,kurt,nfinal,new,error=error
     
     if defined(logger) then begin
        print, $
           'Information (calc_shift_specbox_x): specbox shift calculation uses '+strim(use_num)+' brightest sources...'
        for i=0,use_num-1 do $
           logger->append, $
           ['    Source id '+string(source_table_tmp[sort_key[i]].id)+ $
            ': Flux '+string(source_table[source_table_tmp[sort_key[i]].id].flux)+ $
            ' (ADU): Offset '+string(offset[i]-float((!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2))+' (pix)']
     endif
     
  endif else begin
     meanclip_mod,offset[use_array],mean_offset,sigma_mean_d_offset,weight=weight[use_array],clipsig=3.
;    robomean,offset[use_array],3,0.5,mean_offset,stddev,sigma_mean_d_offset,var,skew,kurt,nfinal,new,error=error
  endelse

  mean_d_offset=mean_offset-float((!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2)

  if sigma_mean_d_offset GT 2. then begin
;    mean_d_offset=0. & sigma_mean_d_offset=0.
     mean_d_offset=median(offset[use_array])-float((!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2)
     sigma_mean_d_offset=0.
     print,'Warning (calc_shift_specbox_x): Data seems too noisy... median value is adopted. '+strim(mean_d_offset)
  endif

end
