pro calc_shift_specbox_y_ng2,wave_array,specimage_wc_1d,source_table,mean_specbox_y_shift,specbox_y_shift, $
                            use_array=use_array,sigma=sigma

  set_spec1d_wc,spec1d_wc_lambda,spec1d_wc
  
  n_source=n_elements(source_table)
  lag=findgen(20)-10.
  specbox_y_shift=fltarr(n_source) & weight=fltarr(n_source)
  
  k=0
  for source_id=0,n_source-1 do begin
     tmp=where(finite(specimage_wc_1d[*,source_id]),count)
     if count/!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy LT 0.5 then continue ; if too much number of NaN pixelse, skip the following.
     n_pix=n_elements(spec1d_wc)
     cor_func=c_correlate(spec1d_wc,specimage_wc_1d[0:n_pix-1,source_id],lag) ; was [0:*]
     if finite(total(cor_func),/NAN) then continue
     result=mpfitpeak_nan(lag,cor_func,A,nterms=5,/positive,dof=dof,perror=perror,bestnorm=bestnorm)
     if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,0,0]
     if A[0] GT 0.2 && max(cor_func) GT 0.2 && error[1] LT 1. && error[1] GT 0.then begin
;       print,error[1],A[0]
;       plot,lag,cor_func,yrange=[0.2,1],psym=10
;       oplot,lag,result,psym=1
        specbox_y_shift[k]=A[1]
;       if finite(source_table[source_id].flux) then weight[k]=A[0]^2.*source_table[source_id].flux else weight[k]=0.
        weight[k]=1./(error[1])^2.

;       print,source_id,A[1],A[0]^2.,source_table[source_id].flux
;       print,A[1],(A[0]+A[3]+A[4])^2.
        k+=1
;       wait,1
     endif
  endfor
  
  if k EQ 0 then begin          ; when there are no good sources found...
     spacebox_y_shift=0
     mean_specbox_y_shift=0
     sigma=0
     print,'Warning (calc_shift_specbox_y_ng2): SPECBOX Y shift could not be measured!'
     return
  endif
  
  specbox_y_shift=specbox_y_shift[0:k-1]-1.0-0.268455+0.5 ; -1.0 is a measured offset.
  weight=weight[0:k-1]
  
  if n_source EQ 1 then mean_specbox_y_shift=specbox_y_shift[0] $
  else meanclip_mod,specbox_y_shift,mean_specbox_y_shift,sigma,clipsig=2.,weight=weight,subs=use_array

end
