pro calc_shift_specbox_y_np,wave_array,specimage_wc_1d,source_table,mean_specbox_y_shift,specbox_y_shift, $
                            sigma_value=sigma_value,use_array=use_array,d_wave_offset_pix=d_wave_offset_pix

  mes_max=20 & mes_min=2 & xarray=findgen(mes_max-mes_min+1)
  set_spec1d_wc,spec1d_wc_lambda,spec1d_wc
  
;fit the NP spec1d_wc peak
  result=mpfitpeak_nan(xarray,spec1d_wc[mes_min:mes_max],A,nterms=5,/positive,errmsg=errmsg)
;another fit for better results
  result=mpfitpeak_nan(xarray,spec1d_wc[mes_min:mes_max]>(A[0]*2./3.),AA, $
                       nterms=4,/positive,dof=dof,perror=perror,bestnorm=bestnorm)
  if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,0.,0.,0.,0.,0.]
; print,'Information (calc_shift_specbox_y_np): template fit position error = '+strim(error[1])
  spec1d_wc_peak_pos=AA[1]
; print,spec1d_wc_peak_pos
 
  if !IRC_SPECRED_MISC.DEBUG then begin
     plot,xarray,spec1d_wc[mes_min:mes_max],psym=10,color=!IRC_SPECRED_COLOR.green
     oplot,xarray,result,color=!IRC_SPECRED_COLOR.red & wait,1
  endif

  calc_np_distortion_cor,specimage_wc_1d,source_table,peak_mean_pos,peak_fit_pos, $
                         use_array=use_array,mes_max=mes_max,mes_min=mes_min,error_array=error_array, $
                         spec1d_wc=spec1d_wc,flux=flux
 
;  calc_np_distortion,specimage_wc_1d,source_table,peak_mean_pos,peak_fit_pos, $
;                     use_array=use_array,mes_max=mes_max,mes_min=mes_min,error_array=error_array, $
;                     spec1d_wc=spec1d_wc,flux=flux
;  peak_fit_pos-=spec1d_wc_peak_pos ;peak fit pos with respet to spec1d_wc peak
;  print,peak_fit_pos

  tmp=where(error_array EQ 0,count)
  if count GT 0 then error_array[tmp]=1e5
; weight=1./(error_array)^2.
  weight=flux
  if total(weight) EQ 0. then weight[*]=1.; when flux is all zero

  specbox_y_shift=peak_fit_pos
  specbox_y_shift+=-0.861625+0.3173-0.5 ; was +1.
  specbox_y_shift-=1.5          ; added on 20071225
  specbox_y_shift+=2.5          ; added on 20071228


; -0.462948: shift of NP for wave_offset_pix=0; for multiple targets
; +0.3173: -(source_table.spec_y-round(source_table.spec_y))
; +1.0; added by experience
  
  n_source=n_elements(specbox_y_shift); source_table
  
  case 1 of
     (n_source EQ 0): begin
         mean_specbox_y_shift=0
         sigma_value=0
      end
     (n_source EQ 1): begin
        mean_specbox_y_shift=specbox_y_shift[0] & sigma_value=0
        print,'Information (calc_shift_specbox_y_np): only 1 source has been used to calculate wave_offst_pix!'
     end
     (n_source GT 5): begin
        meanclip_mod,specbox_y_shift,mean_specbox_y_shift,sigma_value,clipsig=3,weight=weight
        d_wave_offset_pix=source_table.spec_y-round(source_table.spec_y)
        sigma0=robust_sigma_mod(specbox_y_shift)
        sigma1=robust_sigma_mod(specbox_y_shift-d_wave_offset_pix[use_array])
        print,'Information (calc_shift_specbox_y_np): sigma of specbox Y shift measurement (before and after sub-pix correction) = ' $
              +strim(sigma0)+','+strim(sigma1)
     end
     (n_source GT 1 && n_source LE 5): begin
        meanclip_mod,specbox_y_shift,mean_specbox_y_shift,sigma_value,clipsig=3,weight=weight
        d_wave_offset_pix=source_table.spec_y-round(source_table.spec_y)
        print='Information (calc_shift_specbox_y_np): sigma of specbox Y shift measurement (before and after sub-pix correction) = ' $
              +strim(sigma(specbox_y_shift))+','+strim(sigma(specbox_y_shift-d_wave_offset_pix[use_array]))
     end
  endcase
  
  if !IRC_SPECRED_MISC.DEBUG && n_elements(specbox_y_shift) GT 2 then begin
     plot,d_wave_offset_pix[use_array],specbox_y_shift,psym=4,color=!IRC_SPECRED_COLOR.white,xstyle=1,ystyle=1, $
          xrange=[-0.5,0.5],yrange=[median(specbox_y_shift)-3.0,median(specbox_y_shift)+3.0]
     oplot,d_wave_offset_pix[use_array],specbox_y_shift-d_wave_offset_pix[use_array],psym=5,color=!IRC_SPECRED_COLOR.red
;  plot,source_table[use_array].spec_y,specbox_y_shift,psym=4,color=!IRC_SPECRED_COLOR.white,xstyle=0,ystyle=0, $
;       yrange=[median(specbox_y_shift)-2.0,median(specbox_y_shift)+2.0]
;  oplot,source_table[use_array].spec_y,specbox_y_shift-d_wave_offset_pix[use_array],color=!IRC_SPECRED_COLOR.red,psym=5
  endif
  
;oplot,xarray,spec1d_wc[mes_min:mes_max],psym=10,color=!IRC_SPECRED_COLOR.green
;plot,spec1d_wc_lambda,wave_array,color=!IRC_SPECRED_COLOR.white

;  print,peak_mean_pos-0.861625+0.3173-0.5 ; was +1.

end
