function calc_hotpix_scale_fac,image,hotpix_2d,frame_id,hotpix_max

  image_hotpix=image[*,*,frame_id]-median(image[*,*,frame_id],5)
  image_hotpix_1d=reform(reform(image_hotpix,1,n_elements(image_hotpix)))

  hotpix_1d=reform(reform(hotpix_2d,1,n_elements(hotpix_2d)))

  nonnan=where(finite(hotpix_1d),count)

  image_hotpix_1d_nonnan=image_hotpix_1d[nonnan]
  hotpix_1d_nonnan=hotpix_1d[nonnan]
  
  hotpix_min=100.
  good=where( $
       hotpix_1d_nonnan GT hotpix_min AND $
       image_hotpix_1d_nonnan GT hotpix_min AND $
       image_hotpix_1d_nonnan LT hotpix_max AND $
       image_hotpix_1d_nonnan/image_hotpix_1d_nonnan GT 0.5 AND $
       image_hotpix_1d_nonnan/image_hotpix_1d_nonnan LT 2.0, $
       count)
  
  if count GT 10 then begin
;     plot,image_hotpix_1d_nonnan[good],image_hotpix_1d_nonnan[good]/hotpix_1d_nonnan[good],psym=5,xrange=[0,1000],yrange=[0,2],color=!irc_specred_color.black
;     wait,1
     return,median(image_hotpix_1d_nonnan[good]/hotpix_1d_nonnan[good])
  endif else begin
     return,1.
  endelse
end

pro do_hotpixsub,refimage,refimage_short,specimage,specimage_short,refdark_ds_long,refdark_ds_short,superdark, $
                 refimage_hs,specimage_hs,hotpix=hotpix

  if NIR() && !IRC_SPECRED_PROCESSOPTION.warm_mode EQ 0B then begin
                                ; for NIR, do nothing...
     refimage_hs=refimage
     specimage_hs=specimage
     return
  endif

  common gui,logger

  logger->append,['---','Hotpixel correcting...']

; scale_fac=0.6107; original value
; scale_fac=0.7107; tunied value for FOV L7

  if !IRC_SPECRED_PROCESSOPTION.point_remover_mode EQ 1B then begin
     !IRC_SPECRED_PROCESSOPTION.point_remover_mode=0B 
     irc_imcombine_n,refdark_ds_long,refdark_ds_short,refdark_ds_combined,/no_shift
     !IRC_SPECRED_PROCESSOPTION.point_remover_mode=1B
  endif else begin
     irc_imcombine_n,refdark_ds_long,refdark_ds_short,refdark_ds_combined,/no_shift
  endelse
  
  if !IRC_SPECRED_PROCESSOPTION.warm_mode then $
     hotpix_2d=refdark_ds_combined[*,*,1]-sigma_filter(refdark_ds_combined[*,*,1],radius=1,/all,/iter,n_sigma=3.) $
  else $
     hotpix_2d=refdark_ds_combined[*,*,1]-filter_image(refdark_ds_combined[*,*,1],median=5)

  hotpix_2d_org=hotpix_2d

  if !IRC_SPECRED_PROCESSOPTION.warm_mode EQ 0B then $
     hotpix_max=100 $
  else $
     hotpix_max=50             ; was 32767

 if !IRC_SPECRED_PROCESSOPTION.warm_mode EQ 0B then $
     hotpix_min=-100 $
  else $
     hotpix_min=-100

  hottest_pix=where(hotpix_2d GT hotpix_max,count)
  if count GT 0 then hotpix_2d[hottest_pix]=!values.f_nan
  print,'Information (do_hotpixsub): # of hotpixels masked: '+strim(count)

;  coldest_pix=where(hotpix_2d LT hotpix_min,count)
;  if count GT 0 then hotpix_2d[coldest_pix]=!values.f_nan
;  print,'Information (do_hotpixsub): # of coldpixels masked: '+strim(count)

  refimage_hs=refimage
  specimage_hs=specimage

; window,xsize=800,ysize=500

  hotpix_max=10000
  s=size(refimage) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  for frame_id=0,n_frame-1 do begin
 ;   if !IRC_SPECRED_PROCESSOPTION.warm_mode then scale_fac=1.0 else $
     scale_fac=calc_hotpix_scale_fac(refimage,hotpix_2d_org,frame_id,hotpix_max)
     refimage_hs_tmp=refimage[*,*,frame_id]-hotpix_2d*scale_fac
     refimage_hs[*,*,frame_id]=refimage_hs_tmp
  endfor
  
  s=size(specimage) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  for frame_id=0,n_frame-1 do begin
;    if !IRC_SPECRED_PROCESSOPTION.warm_mode then scale_fac=1.0 else $
     scale_fac=calc_hotpix_scale_fac(specimage,hotpix_2d_org,frame_id,hotpix_max)
     specimage_hs_tmp=specimage[*,*,frame_id]-hotpix_2d*scale_fac
     specimage_hs[*,*,frame_id]=specimage_hs_tmp
  endfor

  hotpix=refdark_ds_combined
  hotpix[*,*,1]=hotpix_2d
  hotpix[*,*,0]=hotpix_2d

end
