pro do_image_combine,refimage_ff,refimage_ff_short,refimage_ff_out_shift, $
                     specimage_ff,specimage_ff_short,specimage_ff_out_shift, $
                     weight_spec_long=weight_spec_long,weight_ref_long=weight_ref_long, $
                     weight_spec_short=weight_spec_short,weight_ref_short=weight_ref_short, $
                     noisemap=noisemap,no_crrej=no_crrej, $
                     specimage_ff_shift=specimage_ff_shift,specimage_ff_short_shift=specimage_ff_short_shift,inimage_shift_skyadj=inimage_shift_skyadj, $
                     read_shiftinfo_from_file=read_shiftinfo_from_file, $
                     dx_sl_imag=dx_sl_imag,dy_sl_imag=dy_sl_imag, $
                     dx_sl_spec=dx_sl_spec,dy_sl_spec=dy_sl_spec, $
                     dx_spec=dx_spec,dy_spec=dy_spec
  
; Combine all indiv frames

  common gui,logger

; remove bad short images
  if MIRS() then specimage_ff_short[*,*,1:*]=!values.f_nan
  if MIRL() then begin
     specimage_ff_short[*,*,1:3]=!values.f_nan
     specimage_ff_short[*,*,5:*]=!values.f_nan
  endif
  
  logger->append,['---','Image combining...']

  s=size(specimage_ff) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1

  if !IRC_SPECRED_OBSPARAM.slit_mode || !IRC_SPECRED_OBSPARAM.preflight_mode then begin
;    if  !IRC_SPECRED_OBSPARAM.slit_mode then !IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE='median'
;     print,!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE
     irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out_shift,/NO_SHIFT,rmsimage=noisemap,no_crrej=no_crrej, $
                     clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA
     irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out_shift,/NO_SHIFT,rmsimage=noisemap,no_crrej=no_crrej, $
                     clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA
     if !IRC_SPECRED_MISC.first_pass EQ 0B then begin
        noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
        noisemap_med=filter_image(noisemap_med,median=3)
        irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out_shift,/NO_SHIFT,rmsimage=noisemap,no_crrej=no_crrej, $
                        clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,noisemap_long=noisemap_med

        return
     endif
  endif

   case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        logger->append,['Refimage median averaging.']
        if !IRC_SPECRED_OBSPARAM.AOT NE '02B' then $
           irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out, $
                           comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE, $
                           /IMAG,no_crrej=no_crrej,/no_shift $ ;,/sky_adj $
        else $
           irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out, $
                           comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE, $
                           /IMAG,no_crrej=no_crrej ;,sky_adj ; for 02B there are more than 2 frames to be combined.
        
        if !IRC_SPECRED_PROCESSOPTION.shift_from_file EQ 1B || keyword_set(read_shiftinfo_from_file) then begin
           print,'Information (do_image_combine): NIR subframe offsets will be read from the database'
           if NP() then $
              read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NP_SHIFT_XY.dat' $
           else $
              read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NG_SHIFT_XY.dat'
        endif
        
        if !IRC_SPECRED_OBSPARAM.AOT NE '02B' then begin
           logger->append,['Specimage sigma clipping averaging.']
           irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                           dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE, $
                           clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                           weight_long=weight_spec_long,weight_short=weight_spec_short, $
                           inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                           interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                          inimage_shift_skyadj=inimage_shift_skyadj

;          if defined(dx_sl_imag) then begin
           if !IRC_SPECRED_MISC.first_pass EQ 0B then begin
              noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
;             noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)
              noisemap_med=filter_image(noisemap_med,median=3)
              
              irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                              dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE, $
                              clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                              weight_long=weight_spec_long,weight_short=weight_spec_short, $
                              noisemap_long=noisemap_med, $
                              inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                              interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                             inimage_shift_skyadj=inimage_shift_skyadj
              
;             meanclip_mod,noisemap[*,*,1],avg,sigma,clip=3.
           endif
        endif else begin
           logger->append,['Specimage median averaging.']
           irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                           dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE, $
                           weight_long=weight_spec_long,weight_short=weight_spec_short, $
                           inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                           interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                          inimage_shift_skyadj=inimage_shift_skyadj
           
        endelse

        if !IRC_SPECRED_PROCESSOPTION.shift_from_file NE 1B then begin
           print,'Information (do_image_combine): NIR subframe offsets were written in the database.'
           if NP() && ~ keyword_set(read_shiftinfo_from_file) $
           then write_image_shift_info,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NP_SHIFT_XY.dat' $
           else write_image_shift_info,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NG_SHIFT_XY.dat'
        endif
    end

     1: begin
        logger->append,['Refimage median combining.']
        irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out,$;/sky_adj, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE,/IMAG,no_crrej=no_crrej
        write_image_shift_info,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/S9W_SHIFT_XY.dat'

        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              case 1 of
                 (!IRC_SPECRED_OBSPARAM.AOT NE '04B'): begin
                    print,'Information (do_image_combine): This is AOT04A/C follow-NIR mode, using NP shift data.'
                    read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NP_SHIFT_XY.dat'
                 end
                 (!IRC_SPECRED_OBSPARAM.AOT EQ '04B'): begin
                    print,'Information (do_image_combine): This is AOT04B follow-NIR mode, using NG shift data.'
                    read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NG_SHIFT_XY.dat'
                 end
              endcase

              logger->append,['Specimage sigma clipping averaging.']
              irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                              dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                              clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                              weight_long=weight_spec_long,weight_short=weight_spec_short, $
                              inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                              interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                             inimage_shift_skyadj=inimage_shift_skyadj

;             if defined(dx_sl_imag) then begin
              if !IRC_SPECRED_MISC.first_pass EQ 0B then begin
                 noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
;                 noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)
                 noisemap_med=filter_image(noisemap_med,median=3)
;                noisemap_med=filter_image_nan(noisemap[*,*,1],median=1,/all)
                 
                 irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                                 dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                                 clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                                 weight_long=weight_spec_long,weight_short=weight_spec_short, $
                                 noisemap_long=noisemap_med, $
                                 inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                                 interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                                inimage_shift_skyadj=inimage_shift_skyadj
              endif
           end

           1: begin
              case 1 of
                 (!IRC_SPECRED_OBSPARAM.AOT EQ '04A'): begin
                    print,'Information (do_image_combine): This is AOT04A follow-NIR mode, using NP shift data.'
                    read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NP_SHIFT_XY.dat'
                 end
                 (!IRC_SPECRED_OBSPARAM.AOT EQ '04B' || !IRC_SPECRED_OBSPARAM.AOT EQ '04C'): begin
                    print,'Information (do_image_combine): This is AOT04B/C follow-NIR mode, using NG shift data.'
                    read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NG_SHIFT_XY.dat'
                 end
              endcase
              logger->append,['Specimage sigma clipping averaging.']
              if ~ keyword_set(read_shiftinfo_from_file) then $
                 irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                                 dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                                 clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                                 weight_long=weight_spec_long,weight_short=weight_spec_short, $
                                 inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                                 interp_dx=interp_dx,interp_dy=interp_dy $ ;, $
;                                /subpix $
;                                inimage_shift_skyadj=inimage_shift_skyadj
              else $
                 irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                                 dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                                 clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                                 weight_long=weight_spec_long,weight_short=weight_spec_short, $
                                 inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                                 interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                                /subpix
;                                inimage_shift_skyadj=inimage_shift_skyadj
              
;             if defined(dx_sl_imag) then begin
              if !IRC_SPECRED_MISC.first_pass EQ 0B then begin
;                noisemap_med=filter_image_nan(noisemap[*,*,1],median=1,/all)
                 noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
;                noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)
                 noisemap_med=filter_image(noisemap_med,median=3)
                 if ~ keyword_set(read_shiftinfo_from_file) then $
                    irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                                    dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                                    clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                                    weight_long=weight_spec_long,weight_short=weight_spec_short, $
                                    noisemap_long=noisemap_med, $
                                    inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                                    interp_dx=interp_dx,interp_dy=interp_dy $ ;, $
;                                   /subpix 
;                                   inimage_shift_skyadj=inimage_shift_skyadj
                 else $
                    irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                                    dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                                    clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                                    weight_long=weight_spec_long,weight_short=weight_spec_short, $
                                    noisemap_long=noisemap_med, $
                                    inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                                    interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                                   /subpix
;                                   inimage_shift_skyadj=inimage_shift_skyadj
                 
              endif
           endcase
        end
     end
     
     2: begin
        logger->append,['Refimage median combining.']
        print,'Information (do_image_combine): This is follow-MIRS refimage stacking mode, using S9W shift data.'
        read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/S9W_SHIFT_XY.dat'
        irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE,/IMAG,/follow_NIR, $
                        no_crrej=no_crrej ;,/sky_adj
        case 1 of
           (!IRC_SPECRED_OBSPARAM.AOT EQ '04C'): begin
              print,'Information (do_image_combine): This is AOT04C follow-NIR mode, using both NP and NG shift data.'
              read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NP_SHIFT_XY.dat'
              read_image_shift_info,id,dx2,dy2,filename=!IRC_SPECRED_DIR.workdir+'/NG_SHIFT_XY.dat'
              read_specbox_shift_x,shift_x_np,filename=!IRC_SPECRED_DIR.workdir+'/NP_SPECBOX_SHIFT_X.dat'
              read_specbox_shift_x,shift_x_ng,filename=!IRC_SPECRED_DIR.workdir+'/NG_SPECBOX_SHIFT_X.dat'
;             print,shift_x_np,shift_x_ng
              dx2+=shift_x_ng-shift_x_np ; temp setting
              read_specbox_shift_y,shift_y_ng,filename=!IRC_SPECRED_DIR.workdir+'/NG_SPECBOX_SHIFT_Y.dat'
              read_specbox_shift_y,shift_y_np,filename=!IRC_SPECRED_DIR.workdir+'/NP_SPECBOX_SHIFT_Y.dat'
              dy2+=shift_y_ng-shift_y_np
              dx=[dx,dx2] & dy=[dy,dy2]
           end
           (!IRC_SPECRED_OBSPARAM.AOT EQ '04A'): begin
              print,'Information (do_image_combine): This is AOT04A follow-NIR mode, using NP shift data.'
              read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NP_SHIFT_XY.dat'
           end
           (!IRC_SPECRED_OBSPARAM.AOT EQ '04B'): begin
              print,'Information (do_image_combine): This is AOT04B follow-NIR mode, using NG shift data.'
              read_image_shift_info,id,dx,dy,filename=!IRC_SPECRED_DIR.workdir+'/NG_SHIFT_XY.dat'
           end
       endcase

        logger->append,['Specimage sigma clipping averaging.']
        irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                        clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                        weight_long=weight_spec_long,weight_short=weight_spec_short, $
                        inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                        interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                       inimage_shift_skyadj=inimage_shift_skyadj

;       if defined(dx_sl_imag) then begin
        if !IRC_SPECRED_MISC.first_pass EQ 0B then begin
            noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
;           noisemap_med=filter_image_nan(noisemap[*,*,1],median=3,/all)
;           noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)
            noisemap_med=filter_image(noisemap_med,median=3)
            
            irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                            dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                            clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA, $
                            weight_long=weight_spec_long,weight_short=weight_spec_short, $
                            noisemap_long=noisemap_med, $
                            inimage_shift=specimage_ff_shift,inimage_short_shift=specimage_ff_short_shift,no_crrej=no_crrej, $
                            interp_dx=interp_dx,interp_dy=interp_dy ;, $
;                       inimage_shift_skyadj=inimage_shift_skyadj
        endif
        
        specimage_ff_out=sigma_filter_cube(specimage_ff_out,1,n_sigma=5.)
        refimage_ff_out=sigma_filter_cube(refimage_ff_out,1,n_sigma=5.)
    end

 endcase

; remove any remaining hot pixels...

   if !IRC_SPECRED_PROCESSOPTION.point_remover_mode EQ 1B then begin
      tmp=refimage_ff_out[*,*,1]
      tmp2=point_remover(tmp,3,10,/both)
      refimage_ff_out[*,*,1]=tmp2
      
      tmp=specimage_ff_out[*,*,1]
      tmp2=point_remover(tmp,3,10,/both)
      specimage_ff_out[*,*,1]=tmp2
   endif

   meanclip_mod,noisemap[*,*,1],avg,sigma,clip=3.
   print,'Information (do_image_combine): typical pixel count variation (RMS) in ADU = '+strim(avg/sqrt(n_frame))

; align short and long image

   if ~ !IRC_SPECRED_OBSPARAM.slit_mode then begin
      logger->append,['Adjusting short-long exposure frame shift.']
      irc_align_short_long,refimage_ff_out,refimage_ff_out_shift,dx_sl=dx_sl_imag,dy_sl=dy_sl_imag
      irc_align_short_long,specimage_ff_out,specimage_ff_out_shift,/spec,dx_sl=dx_sl_spec,dy_sl=dy_sl_spec
   endif else begin
      refimage_ff_out_shift=refimage_ff_out
      specimage_ff_out_shift=specimage_ff_out
   endelse

; inpterpolating NAN pixels on reference image
   mask_interp,refimage_ff_out_shift[*,*,1],masked_image
   refimage_ff_out_shift[*,*,1]=masked_image
  
   if defined(interp_dx) then begin
      dx_spec=interp_dx & dy_spec=interp_dy
   endif

end
