pro do_load_images,ext_source_table,refimage_file,specimage_file,darkimage_file, $
                   refimage_wrapcor,refimage_wrapcor_short,specimage_wrapcor,specimage_wrapcor_short, $
                   imageheader,specheader, $
                   superdark,imageflat,specflat,flatcor,refdark_wrapcor_long,refdark_wrapcor_short, $
                   soramame_flag=soramame_flag,no_database_check=no_database_check

  common gui,logger

  if defined(logger) then begin
     logger->append,['Pipeline job for '+strim(!IRC_SPECRED_PROCESSTARGET.targetid)+' '+ $
                     strim(!IRC_SPECRED_PROCESSTARGET.targetsubid)+' '+ $
                     ': '+!IRC_SPECRED_PROCESSTARGET.filter_spec+ $
                     '; AOT:'+!IRC_SPECRED_OBSPARAM.AOT]
     
     logger->append,['---','Loading data...']
  endif

  print,'Pipeline job for '+strim(!IRC_SPECRED_PROCESSTARGET.targetid)+' '+ $
        strim(!IRC_SPECRED_PROCESSTARGET.targetsubid)+' '+ $
        ': '+!IRC_SPECRED_PROCESSTARGET.filter_spec+ $
        '; AOT:'+!IRC_SPECRED_OBSPARAM.AOT
  

  if !IRC_SPECRED_OBSPARAM.preflight_mode then begin
     irc_list_fits_read, refimage_file, refimage_nir, refimage_mirs, refimage_mirl, $
                         n_nir,n_mir, imageheader_nir,imageheader_mirs,imageheader_mirl, $
                         dir=!IRC_SPECRED_DIR.datadir2,/separate
     irc_list_fits_read,specimage_file,specimage_nir,specimage_mirs,specimage_mirl, $
                        n_nir,n_mir, specheader_nir,specheader_mirs,specheader_mirl, $
                        dir=!IRC_SPECRED_DIR.datadir2,/separate
  endif else begin
     check_input_files,ext_source_table,refimage_file,specimage_file,darkimage_file

     irc_list_read,refimage_list,n_refimage,list_in=refimage_file
     if !IRC_SPECRED_OBSPARAM.AOT NE '02B' && n_refimage GT 1 then begin
        print,'Warning (do_load_images): Number of reference image is larger than 1!' + $
              ' Removing the last one from the list' + $
              ' (maybe the file was taken during maneuver/filter wheel rotation)...'
        refimage_list=refimage_list[0]
        n_refimage=1
     endif

; spec data read
     irc_list_read,specimage_list,n_specimage,list_in=specimage_file

     if ~ defined(no_database_check) then analyze_specimage_list,specimage_list

     irc_list_fits_read,specimage_file,specimage_nir,specimage_mirs,specimage_mirl, $
                        n_nir,n_mir, specheader_nir,specheader_mirs,specheader_mirl, $
                        dir=!IRC_SPECRED_DIR.datadir2,imagelist=specimage_list

; dark data read
     irc_list_read,darkimage_list,n_dark,list_in=darkimage_file
     case n_dark of
        3: begin
                                ; remove partial dark (dark that is taken during maneuver)
           darkimage_list_tmp=darkimage_list[0:n_dark-2]
           darkimage_list_tmp[n_dark-2]=darkimage_list[n_dark-1]
           darkimage_list=darkimage_list_tmp
           print,'Warning (do_load_images): remove a set of partial dark!'
        end
        2: begin

           if $
              (!IRC_SPECRED_OBSPARAM.AOT EQ '04A' && (NP() || SG2() || LG2())) || $
              (!IRC_SPECRED_OBSPARAM.AOT EQ '04B' && (NG() || SG2() || LG2())) || $
              (!IRC_SPECRED_OBSPARAM.AOT EQ '04C' && (NG() || SG2() || LG2())) then begin
              if !IRC_SPECRED_PROCESSOPTION.use_all_images_mode EQ 0 then begin
                 n_specimage=n_elements(specimage_list)
                 specimage_list=specimage_list[0:n_specimage-2]
                 print,'Warning (do_load_images):' + $
                       ' removed the last spec image from a list since it is taken during maneuver!'
                 irc_list_fits_read,specimage_file,specimage_nir,specimage_mirs,specimage_mirl, $
                                    n_nir,n_mir, specheader_nir,specheader_mirs,specheader_mirl, $
                                    dir=!IRC_SPECRED_DIR.datadir2,imagelist=specimage_list
              endif else begin
                 print,'Warning (do_load_images):' + $
                       ' the last spec image was taken during maneuver, but is not removed!'
              endelse
           endif
           
           n_specimage=n_elements(specimage_list)
           case 1 of
              NIR(): specheader_tmp=specheader_nir[*,n_specimage-1]
              MIRS(): specheader_tmp=specheader_mirs[*,n_specimage-1]
              MIRL(): specheader_tmp=specheader_mirl[*,n_specimage-1]
           end

           if fix(fxpar(specheader_tmp,'MNV_FLG')) EQ 1 then begin
             if !IRC_SPECRED_PROCESSOPTION.use_all_images_mode EQ 0 then begin
;                n_specimage=n_elements(specimage_list)
                 specimage_list=specimage_list[0:n_specimage-2]
                 print,'Warning (do_load_images):' + $
                       ' removed the last spec image from a list since it is taken during maneuver!'
; reload specimage with revised list
                 irc_list_fits_read,specimage_file,specimage_nir,specimage_mirs,specimage_mirl, $
                                    n_nir,n_mir, specheader_nir,specheader_mirs,specheader_mirl, $
                                    dir=!IRC_SPECRED_DIR.datadir2,imagelist=specimage_list
              endif else begin
                 print,'Warning (do_load_images):' + $
                       ' the last spec image was taken during maneuver, but is not removed!'
              endelse
           endif

        end
        else: begin
           print,'Warning (do_load_images): something is wrong in the dark list!'
        end
     endcase

     irc_list_fits_read,darkimage_file,darkimage_nir,darkimage_mirs,darkimage_mirl, $
                        n_nir,n_mir, darkheader_nir,darkheader_mirs,darkheader_mirl, $
                        dir=!IRC_SPECRED_DIR.datadir2,imagelist=darkimage_list

; refimage read
   
     irc_list_fits_read, refimage_file, refimage_nir, refimage_mirs, refimage_mirl, $
                         n_nir,n_mir, imageheader_nir,imageheader_mirs,imageheader_mirl, $
                         dir=!IRC_SPECRED_DIR.datadir2,imagelist=refimage_list

  endelse

; selecting header

  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin                   ; NIR
        specimage_n=specimage_nir  & refimage_n =refimage_nir
        specheader =specheader_nir & imageheader=imageheader_nir
        if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
           refdark=darkimage_nir
           darkheader=darkheader_nir
        endif
     end
     1: begin                   ; MIRS
        specimage_n=specimage_mirs  & refimage_n =refimage_mirs
        specheader =specheader_mirs & imageheader=imageheader_mirs
        if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
           refdark=darkimage_mirs
           darkheader=darkheader_mirs
        endif
        
     end
     2: begin                   ; MIRL
        specimage_n=specimage_mirl  & refimage_n =refimage_mirl
        specheader =specheader_mirl & imageheader=imageheader_mirl
        if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
           refdark=darkimage_mirl
           darkheader=darkheader_mirl
        endif
     end
  endcase

; check date for soramame check
  datecheck_for_soramame,specheader[*,0],soramame_flag
  
  if soramame_flag then $
     !IRC_SPECRED_PROCESSTARGET.flat_period=0B $
  else $
     !IRC_SPECRED_PROCESSTARGET.flat_period=1B

; following procedures return dark/flat array of specified type
  set_superdark,        superdark,darkheader_tmp
  set_superflat,'image',imageflat,imageheader_tmp ; depending on the flat_period
  set_superflat,'spec', specflat ,specflatheader_tmp ; depending on the flat_period

  if (NIR()) then $
     imrot_NIR,refimage_n,specimage_n,imageflat,specflat,superdark,refdark, $
               imageheader=imageheader,specheader=specheader
                                ; rotate 90deg counter-clockwise to
                                ; match slit dir.

  reform_irc_cube,specimage_n,specimage,specimage_short
  reform_irc_cube, refimage_n,refimage, refimage_short
  reform_irc_cube, refdark,refdark_long, refdark_short

; select only pre-dark
;  refdark_long=refdark_long[*,*,0:2]
;  refdark_short=refdark_short[*,*,0]

; Warp correction

  if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
     wrapcor,specimage,specimage_wrapcor
     wrapcor,specimage_short,specimage_wrapcor_short,/short
;    specimage_wrapcor_short=specimage_short

     wrapcor,refimage,refimage_wrapcor
     wrapcor,refimage_short,refimage_wrapcor_short,/short
;    refimage_wrapcor_short=refimage_short

     wrapcor,refdark_long,refdark_wrapcor_long
     wrapcor,refdark_short,refdark_wrapcor_short,/short
;     refdark_wrapcor_short=refdark_short
  endif else begin
     specimage_wrapcor=specimage
     specimage_wrapcor_short=specimage_short
     refimage_wrapcor=refimage
     refimage_wrapcor_short=refimage_short
     refdark_wrapcor_long=refdark_long
     refdark_wrapcor_short=refdark_short
  endelse

; correcting collumn-pulldown effect; long only
  if NIR() && !IRC_SPECRED_PROCESSOPTION.nir_column_pulldown_correction_mode EQ 1B then begin
;    correct_columnpulldown,specimage_wrapcor,specimage_pulldown & specimage_wrapcor=specimage_pulldown
     correct_columnpulldown_mask,specimage_wrapcor,refimage_wrapcor,specimage_pulldown
     specimage_wrapcor=specimage_pulldown
;    correct_columnpulldown_mask,specimage/4.,specimage_pulldown & specimage_wrapcor=specimage_pulldown
;    correct_columnpulldown,refimage_wrapcor,refimage_pulldown & refimage_wrapcor=refimage_pulldown
  endif

end
