pro do_param_initialize,filter_spec,targetid,targetsubid, $
                        root_dir=root_dir,no_logger_init=no_logger_init, $
                        refimage_list=refimage_list, $
                        reference_fits=reference_fits, $
                        file_in_workdir=file_in_workdir, $
                        no_database_check=no_database_check

  common gui,logger

  !quiet=1                      ; no compile message
  !except=0                     ; disable error reporting
  set_color,/white_bg
  if ~ keyword_set(no_logger_init) then logger_init,logger
  set_dir,targetid,targetsubid,root_dir=root_dir
  
  if keyword_set(file_in_workdir) then begin
      !IRC_SPECRED_DIR.datadir2=!IRC_SPECRED_DIR.workdir
  endif

; FILTER Spec
  if ~ defined(filter_spec) then $
    FILTER_SPEC=dialog_menu(['N3_NP','N3_NG','S9W_SG1','S9W_SG2','L18W_LG2','OTHER'])
  decode_filter_spec,filter_spec

  !IRC_SPECRED_PROCESSTARGET.filter_spec=filter_spec

  if defined(targetid) then !IRC_SPECRED_PROCESSTARGET.targetid=targetid
  if defined(targetsubid) then !IRC_SPECRED_PROCESSTARGET.targetsubid=targetsubid

  set_specextractparam
  if !IRC_SPECRED_OBSPARAM.Np_mode then !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx+=15; widen the width to cover entire Np area
  set_chipinfo
  set_specinfo
  set_areainfo
  
; check required list files before starting the processes
  if defined(refimage_list) || defined(reference_fits) then begin
     if defined(refimage_list) then begin
        check_file,!IRC_SPECRED_DIR.datadir2+'/'+refimage_list
        READCOL,!IRC_SPECRED_DIR.datadir2+'/'+refimage_list, FORMAT='A', imagename,/silent
        imagename=!IRC_SPECRED_DIR.datadir2+'/'+imagename
     endif else begin
        if defined(reference_fits) then begin
           check_file,!IRC_SPECRED_DIR.datadir2+'/'+reference_fits
           imagename=!IRC_SPECRED_DIR.datadir2+'/'+reference_fits
        endif
     endelse
     
; find AOT info
     get_aot_info_irc,imagename[0]
     
  endif
  
  set_operation_mode
  set_process_params

  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0 && !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B $
     && ~ keyword_set(no_database_check) then check_database ; check database files
  
; initialzie relative X shift of spec extraction box
  !IRC_SPECRED_SPECEXTRACTPARAM.x_offset_rel=0.

  !IRC_SPECRED_MASKPARAM.objmask_expand_fac=1. ;was 3
  !IRC_SPECRED_MASKPARAM.circularmask_expand_fac=1.5

  if !IRC_SPECRED_OBSPARAM.AOT EQ '02B' then begin
     !IRC_SPECRED_COMBINEPARAM.crosscor_min_fac=5.
     !IRC_SPECRED_COMBINEPARAM.crosscor_max_fac=30.
     !IRC_SPECRED_COMBINEPARAM.crosscor_abs_max=10000.
  endif else begin
     !IRC_SPECRED_COMBINEPARAM.crosscor_min_fac=3.
     !IRC_SPECRED_COMBINEPARAM.crosscor_max_fac=10000.
     !IRC_SPECRED_COMBINEPARAM.crosscor_abs_max=100. ; was 10000.
  endelse
  


end
