pro do_skysub_n,source_table,specimage_n,specimage_n_short,mask_specimage_n_remove_all_source, $
                specimage_n_bg,specimage_n_bg_short, $
                fov_mask=fov_mask,mmm=mmm, $
                noisemap_n=noisemap_n,noisemap_short_n=noisemap_short_n, $
                noise_mask=noise_mask,no_noise_update=no_noise_update, $
                fit_y_width=fit_y_width,objmask=objmask,no_logger=no_logger, $
                n_frame_long=n_frame_long,n_frame_short=n_frame_short; added on July 2010

; do residual sky subtraction for each extracted specimage
  common gui,logger

  if ~ defined(mask_specimage_n_remove_all_source) then $
     make_mask_n,source_table,mask_specimage_n_remove_all_source,/remove_all,objmask=objmask
;  if ~ defined(mask_specimage_n) then make_mask_n,source_table,mask_specimage_n,fov_mask=fov_mask,noise_mask=noise_mask
;  if ~ defined(mask_specimage_n_remove_all_source) then $
;     make_mask_n,source_table,mask_specimage_n_remove_all_source,/remove_all_source,fov_mask=fov_mask,noise_mask=noise_mask

  if defined(noisemap_n) then weightmap_n=1./noisemap_n^2.

  if !IRC_SPECRED_OBSPARAM.Ns_mode || !IRC_SPECRED_OBSPARAM.Nh_mode || !IRC_SPECRED_OBSPARAM.Ls_mode then begin
     n_source=n_elements(source_table)
     specimage_n_bg=specimage_n
     specimage_n_bg_short=specimage_n_short
     sigma_ADU=fltarr(n_source) ; zero!
     sigma_ADU_short=fltarr(n_source) ; zero!
     if defined(noisemap_n) then begin

; This is only good for slit spec
; added /sqrt(n_frame) to correct noise level for slit spectroscopy,
; which utilize noiseimage (or more specifically, source_table.spec_bgnoise_ADU)
; to measure the error bars for the spectra.
; modified on July 2010

        for source_id=0,n_source-1 do begin
;           print,n_frame_long,n_frame_short
           sigma_ADU[source_id]=median(noisemap_n[*,*,source_id])/sqrt(float(n_frame_long))
           sigma_ADU_short[source_id]=median(noisemap_short_n[*,*,source_id])/sqrt(float(n_frame_short))
        endfor
     endif
  endif else begin
     if ~ defined(no_logger) then logger->append,[['---','Sky-subtracting (local) from all extracted spectra...']]
     if NP() || keyword_set(mmm) then begin
        ; for long
        irc_skysub_n,source_table,specimage_n,mask_specimage_n_remove_all_source,specimage_n_bg,sigma_ADU, $
                     weightmap3d=weightmap_n,noisemap3d=noisemap_n,/mmm,fit_y_width=fit_y_width,no_logger=no_logger
        ; for short
        irc_skysub_n,source_table,specimage_n_short,mask_specimage_n_remove_all_source,specimage_n_bg_short,sigma_ADU_short, $
                     weightmap3d=weightmap_n_short,noisemap3d=noisemap_n_short,/mmm,fit_y_width=fit_y_width,no_logger=no_logger
     endif else begin
        ; for long
        irc_skysub_n,source_table,specimage_n,mask_specimage_n_remove_all_source,specimage_n_bg,sigma_ADU, $
                     weightmap3d=weightmap_n,noisemap3d=noisemap_n,fit_y_width=fit_y_width,no_logger=no_logger
        ; for short
        irc_skysub_n,source_table,specimage_n_short,mask_specimage_n_remove_all_source,specimage_n_bg_short,sigma_ADU_short, $
                     weightmap3d=weightmap_n_shortx,noisemap3d=noisemap_n_short,fit_y_width=fit_y_width,no_logger=no_logger
     endelse
  endelse

  if ~ defined(no_noise_update) then begin  
     source_table.spec_bgnoise_ADU=sigma_ADU
     source_table.spec_bgnoise_ADU_short=sigma_ADU_short
     print,'Information (do_skysub_n): typical skynoise (RMS in ADU) = '+strim(sigma_ADU[0])
  endif
  
end
