pro do_wavecalib,specimage_n_sff,specimage_n_sff_short, $
                 source_table, $
                 specimage_n_wc,specimage_n_wc_short, $
                 wave_array, $
                 use_array=use_array, $
                 specbox_y_shift=specbox_y_shift,no_wave_offset_pix_calc=no_wave_offset_pix_calc, $
                 space_shift=space_shift,nsum=nsum, $
                 d_wave_offset_pix=d_wave_offset_pix

; Wavelength calibration

; by default, wavelength zero point will be
; calculated by themselves (NP/NG)
; set from database (file) of NP/NG offsets (calculated with previous run)

  common gui,logger

  if defined(logger) then logger->append,['---','Wavelength calibrating...']
  if finite(!IRC_SPECRED_SPECPARAM.wave_offset_pix,/NAN) then $
     preset_wave_offset_pix,dir=!IRC_SPECRED_DIR.workdir
  
  if NIR() && ~ keyword_set(no_wave_offset_pix_calc) && $
     (!IRC_SPECRED_OBSPARAM.slit_mode EQ 0B && !IRC_SPECRED_OBSPARAM.Np_mode EQ 0B) && $
     !IRC_SPECRED_PROCESSOPTION.shift_from_file EQ 0B then begin
     irc_wavecalib,specimage_n_sff,source_table,specimage_n_wc,wave_array
     irc_wavecalib,specimage_n_sff_short,source_table,specimage_n_wc_short,wave_array_short
     make_spec1d,specimage_n_wc,specimage_n_fc,mask_specimage_n,sigmaimage_n_fc,source_table, $
                 specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d,/stdstar_mode, $ ; was ,/no_mask
                 space_shift=space_shift,nsum=nsum
     if !IRC_SPECRED_PROCESSOPTION.shift_from_file EQ 0 && !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0 then begin
; do calculation on working images
        case 1 of
           (NP()): begin
              calc_shift_specbox_y_np,wave_array,specimage_wc_1d,source_table,mean_specbox_y_shift,specbox_y_shift, $
                                      sigma=sigma,use_array=use_array,d_wave_offset_pix=d_wave_offset_pix
              !IRC_SPECRED_SPECPARAM.wave_offset_pix=-mean_specbox_y_shift
              write_specbox_shift_y,filename=!IRC_SPECRED_DIR.workdir+'/NP_SPECBOX_SHIFT_Y.dat'
           end
           (NG()): begin
              calc_shift_specbox_y_ng2,wave_array,specimage_wc_1d,source_table,mean_specbox_y_shift,specbox_y_shift, $
                                       sigma=sigma,use_array=use_array
              !IRC_SPECRED_SPECPARAM.wave_offset_pix=-mean_specbox_y_shift
              write_specbox_shift_y,filename=!IRC_SPECRED_DIR.workdir+'/NG_SPECBOX_SHIFT_Y.dat'
           end
        endcase
;       tmp=where(use_array NE 0,n_measured)
        n_measured=n_elements(use_array)
        if defined(logger) then logger->append,['  measured wavelength offset: ' $
                                                +strim(!IRC_SPECRED_SPECPARAM.wave_offset_pix) $
                                                +'+-'+strim(sigma)+' (pix); (n_data = '+strim(n_measured)+')']
        print,'  measured wavelength offset: ' $
              +strim(!IRC_SPECRED_SPECPARAM.wave_offset_pix) $
              +'+-'+strim(sigma)+' (pix); (n_data = '+strim(n_measured)+')'
     endif
; update wave_array with new wave_offset_pix value.
     wave_array=get_wavelength()
  endif else begin
     if defined(logger) then $
        logger->append,['  adopted offset along wavelength dir.: ' $
                        +strim(!IRC_SPECRED_SPECPARAM.wave_offset_pix)+' (pix)']
     irc_wavecalib,specimage_n_sff,source_table,specimage_n_wc,wave_array
     irc_wavecalib,specimage_n_sff_short,source_table,specimage_n_wc_short,wave_array_short
  endelse
  
; for maintenance only
  if !IRC_SPECRED_PROCESSOPTION.no_NP_distortion_mode then !IRC_SPECRED_SPECPARAM.wave_offset_pix=0.
  
end
