pro draw_aperture,space_shift,nsum,x_winsize,y_winsize,yrange=yrange,linecolor=linecolor

  set_plot_pos,off1,off2,cen_off,space_shift,nsum
  
  plot,[0,x_winsize],[space_shift+cen_off,space_shift+cen_off], yrange=yrange,$
       color=!IRC_SPECRED_COLOR.black,/noerase,ytitle='space offset (pix)',xtickinterval=x_winsize*2,xminor=1 ; no minor ticks

  if NP() then begin
;    x1=20./!irc_specred_specextractparam.specaper_dy*x_winsize
     x1=0.
     x2=x_winsize
  endif else begin
     x1=0.
     x2=x_winsize
  endelse

  oplot,[x1,x2],[float(space_shift)+off1,float(space_shift)+off1],color=linecolor
  oplot,[x1,x2],[float(space_shift)-off2,float(space_shift)-off2],color=linecolor
 
;  if NP() then begin            ; widen the width for otamajakusi no atama
;     nsum=nsum+6
;     set_plot_pos,off1,off2,cen_off,space_shift,nsum
;     nsum=nsum-6
;     oplot,[0.,20./!irc_specred_specextractparam.specaper_dy*x_winsize],[float(space_shift)+off1,float(space_shift)+off1],color=linecolor
;     oplot,[0.,20./!irc_specred_specextractparam.specaper_dy*x_winsize],[float(space_shift)-off2,float(space_shift)-off2],color=linecolor
;  endif

end

pro set_plot_pos,off1,off2,cen_off,space_shift,nsum

  if NP() || SG1() || SG2() then begin
     if (nsum mod 2) EQ 1 then begin
        off1=(nsum-1.)/2.+0.5
        off2=(nsum-1.)/2.+0.5
        cen_off=0.
     endif else begin
        off1=nsum/2.+0.5
        off2=nsum/2.+0.5-1.0
        cen_off=0.5
     endelse
  endif else begin
     if (nsum mod 2) EQ 1 then begin
        off1=(nsum-1.)/2.+0.5
        off2=(nsum-1.)/2.+0.5
        cen_off=0.
     endif else begin
        off1=nsum/2.+0.5
        off2=nsum/2.+0.5-1.0
        cen_off=-0.5
     endelse
  endelse

end

pro draw_tv,specimage_n_wc,specmask_n,wave_array,source_id, $
            sigma_filter_set=sigma_filter_set, $
            tvtop=tvtop,tvbottom=tvbottom,margin=margin,x_winsize=x_winsize,y_winsize=y_winsize,ps=ps, $
            bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset,bg_show=bg_show,bg_oneside=bg_oneside, $
            space_shift=space_shift,nsum=nsum,space_smooth=space_smooth

  if keyword_set(sigma_filter_set) then $
     specimage_n_wc_tmp=sigma_filter(specimage_n_wc[*,*,source_id]*specmask_n[*,*,source_id],radius=1,/all,/iterate) $
  else $
     specimage_n_wc_tmp=specimage_n_wc[*,*,source_id]*specmask_n[*,*,source_id]

  masked_region=where(finite(specimage_n_wc_tmp,/NAN),count)

  if ~ defined(space_smooth) then space_smooth=1 ; was nsum  
; if ~ defined(!IRC_SPECRED_PLOTPARAM.smooth) then begin
  if (!IRC_SPECRED_PLOTPARAM.smooth EQ 0 || !IRC_SPECRED_PLOTPARAM.smooth EQ 1) && (space_smooth EQ 0 || space_smooth EQ 1) then begin
;    smooth_width=1
     rotated_image=rotate(specimage_n_wc_tmp,3)
  endif else begin
     smoothed_image=smooth(specimage_n_wc_tmp,[space_smooth,!IRC_SPECRED_PLOTPARAM.smooth],/NAN)
     if count GT 0 then smoothed_image[masked_region]=!values.f_nan
     rotated_image=rotate(smoothed_image,3)
  endelse

  if LG2() || NG() then rotated_image=reverse(rotated_image)

  s=size(rotated_image) & width=s[2]

  if ~ defined(tvtop) then begin
     get_valid_y_range,cut_in,cut_out
     tvtop=max(rotated_image[cut_in:cut_out,width/2-2:width/2+2],/nan)*1.1
  endif
  
  if ~ defined(tvbottom) then begin
     get_valid_y_range,cut_in,cut_out
     tvbottom=min(rotated_image[cut_in:cut_out,width/2-2:width/2+2],/nan)
  endif

  if ~ defined(PS) then begin
     tv,congrid( $
        bytscl(rotated_image,max=tvtop,min=tvbottom) $
        ,x_winsize*(1.0-margin*2.),y_winsize/2.*(1.0-margin*2.) $
               ) $
        ,x_winsize*margin,y_winsize/2.*margin
  endif else begin
     tv,congrid( $
        bytscl(rotated_image,max=tvtop,min=tvbottom) $
        ,x_winsize*(1.0-margin*2.),y_winsize/2.*(1.0-margin*2.) $
               ) $
        ,29.7*margin,21.0/2.*margin,$
;        xsize=10,ysize=10, $
        /centimeters,$
        xsize=29.7*(1.0-margin*2),ysize=21.0*(1.0-margin*2.)/2.
  endelse
  
; !p.position=[margin,0.5*margin,1.0-margin,0.5*(1.0-margin)]
  
  if NP() || SG1() || SG2() then $
;     !Y.range=[+(!irc_specred_specextractparam.specaper_dx-1)/2, $
;               -(!irc_specred_specextractparam.specaper_dx-1)/2] $
               yrange=[+(!irc_specred_specextractparam.specaper_dx-1)/2, $
                       -(!irc_specred_specextractparam.specaper_dx-1)/2] $
  else $
;     !Y.range=[+(!irc_specred_specextractparam.specaper_dx-1)/2, $
;               -(!irc_specred_specextractparam.specaper_dx-1)/2]
               yrange=[+(!irc_specred_specextractparam.specaper_dx-1)/2, $
                         -(!irc_specred_specextractparam.specaper_dx-1)/2]

  draw_aperture,space_shift,nsum,x_winsize,y_winsize,linecolor=!IRC_SPECRED_COLOR.red,yrange=yrange

  if keyword_set(bg_show) then begin
     draw_aperture,space_shift+bg_offset,nsum,x_winsize,y_winsize,linecolor=!IRC_SPECRED_COLOR.green,yrange=yrange
     if ~ keyword_set(bg_oneside) then $
        draw_aperture,space_shift-bg_offset,nsum,x_winsize,y_winsize,linecolor=!IRC_SPECRED_COLOR.green,yrange=yrange
  endif

  if NG() then tick_interval=25. else tick_interval=10.

  if NP() then begin
     axis,xaxis=0,xrange=[0,!irc_specred_specextractparam.specaper_dy], $
          color=!IRC_SPECRED_COLOR.red,xtitle='Pixel',xtickinterval=10
     xtick_location=indgen(fix(!irc_specred_specextractparam.specaper_dy/tick_interval)+1)*tick_interval
     xtick_name=wave_array(xtick_location)
     axis,xaxis=1,xrange=[0,!irc_specred_specextractparam.specaper_dy],color=!IRC_SPECRED_COLOR.red, $
          xtickinterval=tick_interval,xtickv=xtick_location,xtickname=xtick_name
  endif else begin
     tick_pos=[2.,3.,4.,5.,6.,7.,8.,9.,10.,11.,12.,13.,14.,15.,16.,17.,18.,19.,20.,21.,22.,23.,24.,25.,26.]
     n_tics=n_elements(tick_pos)
     x_range_set=[wave_array[0],wave_array[n_elements(wave_array)-1]]
     if NG() || LG2() then x_range_set=[x_range_set[1],x_range_set[0]]
     axis,xaxis=1,xrange=x_range_set,color=!IRC_SPECRED_COLOR.red, $
          xticks=n_tics,xtickv=tick_pos,xtitle='Wavelength (um)'
  endelse

  !X.range=0 & !Y.range=0
  
end
